/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.Task;
import org.eclipse.ant.internal.ui.preferences.AddCustomDialog;
import org.eclipse.ant.internal.ui.preferences.AntObjectLabelProvider;
import org.eclipse.ant.internal.ui.preferences.AntPage;
import org.eclipse.ant.internal.ui.preferences.AntPreferencesMessages;
import org.eclipse.ant.internal.ui.preferences.AntRuntimePreferencePage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class AntTasksPage
extends AntPage {
    private static final int ADD_TASK_BUTTON = 1025;
    private static final int EDIT_TASK_BUTTON = 1026;
    private static final int REMOVE_BUTTON = 1027;
    private final AntObjectLabelProvider labelProvider = new AntObjectLabelProvider();

    public AntTasksPage(AntRuntimePreferencePage preferencePage) {
        super(preferencePage);
    }

    protected void addButtonsToButtonGroup(Composite parent) {
        this.createPushButton(parent, AntPreferencesMessages.getString("AntTasksPage.1"), 1025);
        this.editButton = this.createPushButton(parent, AntPreferencesMessages.getString("AntTasksPage.2"), 1026);
        this.removeButton = this.createPushButton(parent, AntPreferencesMessages.getString("AntTasksPage.3"), 1027);
    }

    private void addTask() {
        String title = AntPreferencesMessages.getString("AntTasksPage.addTaskDialogTitle");
        AddCustomDialog dialog = this.getCustomDialog(title, "org.eclipse.ant.ui.add_task_dialog_context");
        if (dialog.open() == 1) {
            return;
        }
        Task task = new Task();
        task.setTaskName(dialog.getName());
        task.setClassName(dialog.getClassName());
        task.setLibraryEntry(dialog.getLibraryEntry());
        this.addContent(task);
    }

    private AddCustomDialog getCustomDialog(String title, String helpContext) {
        Iterator tasks = this.getContents(true).iterator();
        ArrayList<String> names = new ArrayList<String>();
        while (tasks.hasNext()) {
            Task task = (Task)tasks.next();
            names.add(task.getTaskName());
        }
        AddCustomDialog dialog = new AddCustomDialog(this.getShell(), this.getPreferencePage().getLibraryEntries(), names, helpContext);
        dialog.setTitle(title);
        dialog.setAlreadyExistsErrorMsg(AntPreferencesMessages.getString("AntTasksPage.8"));
        dialog.setNoNameErrorMsg(AntPreferencesMessages.getString("AntTasksPage.9"));
        return dialog;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                this.addTask();
                break;
            }
            case 1026: {
                this.edit(this.getSelection());
                break;
            }
            case 1027: {
                this.remove();
            }
        }
    }

    protected TabItem createTabItem(TabFolder folder) {
        TabItem item = new TabItem(folder, 0);
        item.setText(AntPreferencesMessages.getString("AntTasksPage.title"));
        item.setImage(this.labelProvider.getTaskImage());
        item.setData((Object)this);
        Composite top = new Composite((Composite)folder, 0);
        top.setFont(folder.getFont());
        item.setControl((Control)this.createContents(top));
        this.connectToFolder(item, folder);
        return item;
    }

    protected void edit(IStructuredSelection selection) {
        Task task = (Task)selection.getFirstElement();
        String title = AntPreferencesMessages.getString("AntTasksPage.editTaskDialogTitle");
        AddCustomDialog dialog = this.getCustomDialog(title, "org.eclipse.ant.ui.edit_task_dialog_context");
        dialog.setClassName(task.getClassName());
        dialog.setName(task.getTaskName());
        dialog.setLibraryEntry(task.getLibraryEntry());
        if (dialog.open() == 1) {
            return;
        }
        task.setTaskName(dialog.getName());
        task.setClassName(dialog.getClassName());
        task.setLibraryEntry(dialog.getLibraryEntry());
        this.updateContent(task);
    }

    protected ITableLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    protected void initialize() {
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        this.setInput(prefs.getTasks());
    }

    protected String getHelpContextId() {
        return "org.eclipse.ant.ui.ant_tasks_page_context";
    }
}

