/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.util.Date;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.ui.HistoryView;

public class HistoryFilter
extends ViewerFilter {
    private HistoryView view;
    public String author;
    public Date fromDate;
    public Date toDate;
    public String comment;
    public boolean isOr;

    public HistoryFilter(HistoryView hView, String author, String comment, Date fromDate, Date toDate, boolean isOr) {
        this.view = hView;
        this.author = author;
        this.comment = comment;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.isOr = isOr;
    }

    public boolean select(Viewer aviewer, Object parentElement, Object element) {
        if (element instanceof ILogEntry) {
            ILogEntry entry = (ILogEntry)element;
            if (this.isOr) {
                return this.hasAuthor() && this.authorMatch(entry) || this.hasDate() && this.dateMatch(entry) || this.hasComment() && this.commentMatch(entry);
            }
            return !(this.hasAuthor() && !this.authorMatch(entry) || this.hasDate() && !this.dateMatch(entry) || this.hasComment() && !this.commentMatch(entry));
        }
        return false;
    }

    protected boolean authorMatch(ILogEntry entry) {
        return entry.getAuthor().equals(this.author);
    }

    protected boolean commentMatch(ILogEntry entry) {
        return entry.getComment().toLowerCase().indexOf(this.comment.toLowerCase()) != -1;
    }

    protected boolean dateMatch(ILogEntry entry) {
        return this.fromDate.before(entry.getDate()) && this.toDate.after(entry.getDate());
    }

    protected boolean hasAuthor() {
        return !this.author.equals("");
    }

    protected boolean hasComment() {
        return !this.comment.equals("");
    }

    protected boolean hasDate() {
        return this.fromDate != null && this.toDate != null;
    }
}

