/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.connection.CVSServerException;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.BranchPromptDialog;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;
import org.eclipse.team.internal.ccvs.ui.operations.RepositoryProviderOperation;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.ui.IWorkbenchPart;

public class BranchOperation
extends RepositoryProviderOperation {
    private boolean update;
    private CVSTag rootVersionTag;
    private CVSTag branchTag;

    public BranchOperation(IWorkbenchPart part, IResource[] resources) {
        super(part, resources);
    }

    public void setTags(CVSTag rootVersionTag, CVSTag branchTag, boolean updateToBranch) {
        this.rootVersionTag = rootVersionTag;
        this.branchTag = branchTag;
        this.update = updateToBranch;
    }

    protected boolean shouldRun() {
        IResource[] resources = this.getResources();
        boolean allSticky = this.areAllResourcesSticky(resources);
        ICVSFolder folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)resources[0].getProject());
        BranchPromptDialog dialog = new BranchPromptDialog(this.getShell(), Policy.bind("BranchWizard.title"), folder, allSticky, this.calculateInitialVersionName(resources, allSticky));
        if (dialog.open() != 0) {
            return false;
        }
        String tagString = dialog.getBranchTagName();
        this.update = dialog.getUpdate();
        String versionString = dialog.getVersionTagName();
        this.rootVersionTag = versionString == null ? null : new CVSTag(versionString, 2);
        this.branchTag = new CVSTag(tagString, 1);
        if (this.update) {
            try {
                if (!CVSAction.checkForMixingTags(this.getShell(), resources, this.branchTag)) {
                    return false;
                }
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
        }
        return super.shouldRun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(CVSTeamProvider provider, IResource[] providerResources, IProgressMonitor monitor) throws CVSException, InterruptedException {
        try {
            monitor.beginTask(null, 100);
            this.makeBranch(provider, providerResources, this.rootVersionTag, this.branchTag, this.update, Policy.subMonitorFor(monitor, 90));
            this.updateRememberedTags(providerResources);
            if (this.update) {
                this.updateWorkspaceSubscriber(provider, this.getCVSArguments(providerResources), Policy.subMonitorFor(monitor, 10));
            }
            this.collectStatus(Status.OK_STATUS);
        }
        catch (TeamException e) {
            this.collectStatus(e.getStatus());
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeBranch(CVSTeamProvider provider, IResource[] resources, CVSTag versionTag, CVSTag branchTag, boolean moveToBranch, IProgressMonitor monitor) throws TeamException {
        int totalWork = (versionTag != null ? 60 : 40) + (moveToBranch ? 20 : 0);
        monitor.beginTask(Policy.bind("CVSTeamProvider.makeBranch"), totalWork);
        try {
            ICVSResource[] arguments = this.getCVSArguments(resources);
            IStatus status = null;
            if (versionTag != null) {
                Session session = new Session(this.getRemoteLocation(provider), this.getLocalRoot(provider), true);
                session.open(Policy.subMonitorFor(monitor, 5), true);
                try {
                    status = Command.CUSTOM_TAG.execute(session, Command.NO_GLOBAL_OPTIONS, Command.NO_LOCAL_OPTIONS, versionTag, arguments, null, Policy.subMonitorFor(monitor, 35));
                }
                finally {
                    session.close();
                }
                if (status.isOK()) {
                    session = new Session(this.getRemoteLocation(provider), this.getLocalRoot(provider), true);
                    session.open(Policy.subMonitorFor(monitor, 5), true);
                    try {
                        status = Command.CUSTOM_TAG.execute(session, Command.NO_GLOBAL_OPTIONS, Command.NO_LOCAL_OPTIONS, branchTag, arguments, null, Policy.subMonitorFor(monitor, 15));
                    }
                    finally {
                        session.close();
                    }
                }
            } else {
                Session session = new Session(this.getRemoteLocation(provider), this.getLocalRoot(provider), true);
                session.open(Policy.subMonitorFor(monitor, 5), true);
                try {
                    status = Command.CUSTOM_TAG.execute(session, Command.NO_GLOBAL_OPTIONS, Command.NO_LOCAL_OPTIONS, branchTag, arguments, null, Policy.subMonitorFor(monitor, 35));
                }
                finally {
                    session.close();
                }
            }
            if (!status.isOK()) {
                throw new CVSServerException(status);
            }
            if (moveToBranch) {
                this.setTag(provider, resources, branchTag, Policy.subMonitorFor(monitor, 20));
            }
        }
        finally {
            monitor.done();
        }
    }

    private void setTag(final CVSTeamProvider provider, final IResource[] resources, final CVSTag tag, IProgressMonitor monitor) throws TeamException {
        this.getLocalRoot(provider).run(new ICVSRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(IProgressMonitor progress) throws CVSException {
                try {
                    progress.beginTask(null, 100);
                    IProgressMonitor monitor = Policy.infiniteSubMonitorFor(progress, 100);
                    monitor.beginTask(Policy.bind("CVSTeamProvider.folderInfo", provider.getProject().getName()), 512);
                    for (int i = 0; i < resources.length; ++i) {
                        CVSWorkspaceRoot.getCVSResourceFor((IResource)resources[i]).accept(new ICVSResourceVisitor(this, monitor){
                            private final /* synthetic */ IProgressMonitor val$monitor;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$monitor = val$monitor;
                            }

                            public void visitFile(ICVSFile file) throws CVSException {
                                this.val$monitor.worked(1);
                                byte[] syncBytes = file.getSyncBytes();
                                if (syncBytes != null) {
                                    this.val$monitor.subTask(Policy.bind("CVSTeamProvider.updatingFile", file.getName()));
                                    file.setSyncBytes(ResourceSyncInfo.setTag((byte[])syncBytes, (CVSTag)1.access$000(this.this$1)), 0);
                                }
                            }

                            public void visitFolder(ICVSFolder folder) throws CVSException {
                                this.val$monitor.worked(1);
                                FolderSyncInfo info = folder.getFolderSyncInfo();
                                if (info != null) {
                                    this.val$monitor.subTask(Policy.bind("CVSTeamProvider.updatingFolder", info.getRepository()));
                                    folder.setFolderSyncInfo(new FolderSyncInfo(info.getRepository(), info.getRoot(), 1.access$000(this.this$1), info.getIsStatic()));
                                    folder.acceptChildren((ICVSResourceVisitor)this);
                                }
                            }
                        });
                    }
                }
                finally {
                    progress.done();
                }
            }

            static /* synthetic */ CVSTag access$000(1 x0) {
                return x0.tag;
            }
        }, monitor);
    }

    private void updateRememberedTags(IResource[] providerResources) throws CVSException {
        if (this.rootVersionTag != null || this.update) {
            for (int i = 0; i < providerResources.length; ++i) {
                ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)providerResources[i]);
                RepositoryManager manager = CVSUIPlugin.getPlugin().getRepositoryManager();
                if (this.rootVersionTag != null) {
                    manager.addTags(cvsResource, new CVSTag[]{this.rootVersionTag});
                }
                if (!this.update) continue;
                manager.addTags(cvsResource, new CVSTag[]{this.branchTag});
            }
        }
    }

    protected String getTaskName() {
        return Policy.bind("BranchOperation.0");
    }

    protected String getTaskName(CVSTeamProvider provider) {
        return Policy.bind("BranchOperation.1", provider.getProject().getName());
    }

    private boolean areAllResourcesSticky(IResource[] resources) {
        for (int i = 0; i < resources.length; ++i) {
            if (this.hasStickyTag(resources[i])) continue;
            return false;
        }
        return true;
    }

    private boolean hasStickyTag(IResource resource) {
        try {
            int tagType;
            CVSTag tag;
            ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
            if (cvsResource.isFolder()) {
                FolderSyncInfo folderInfo = ((ICVSFolder)cvsResource).getFolderSyncInfo();
                tag = folderInfo.getTag();
            } else {
                ResourceSyncInfo info = cvsResource.getSyncInfo();
                tag = info.getTag();
            }
            if (tag != null && (tagType = tag.getType()) == 2) {
                return true;
            }
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
            return false;
        }
        return false;
    }

    private String calculateInitialVersionName(IResource[] resources, boolean allSticky) {
        String versionName = "";
        try {
            if (allSticky) {
                IResource stickyResource = resources[0];
                if (stickyResource.getType() == 1) {
                    ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)((IFile)stickyResource));
                    versionName = cvsFile.getSyncInfo().getTag().getName();
                } else {
                    ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)((IContainer)stickyResource));
                    versionName = cvsFolder.getFolderSyncInfo().getTag().getName();
                }
            }
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
            versionName = "";
        }
        return versionName;
    }
}

