/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import java.text.DateFormat;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.HistoryView;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;

public class ChangeLogDiffNode
extends SynchronizeModelElement {
    private ILogEntry logEntry;

    public ChangeLogDiffNode(ISynchronizeModelElement parent, ILogEntry logEntry) {
        super((IDiffContainer)parent);
        this.logEntry = logEntry;
    }

    public ILogEntry getComment() {
        return this.logEntry;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ChangeLogDiffNode)) {
            return false;
        }
        ChangeLogDiffNode other = (ChangeLogDiffNode)((Object)obj);
        ILogEntry otherLog = other.getComment();
        ILogEntry thisLog = this.getComment();
        return thisLog.getComment().equals(otherLog.getComment()) && thisLog.getAuthor().equals(otherLog.getAuthor());
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return CVSUIPlugin.getPlugin().getImageDescriptor("obj16/changelog_obj.gif");
    }

    public String getName() {
        String date = DateFormat.getDateTimeInstance().format(this.logEntry.getDate());
        String comment = HistoryView.flattenText(this.logEntry.getComment());
        return "[" + this.logEntry.getAuthor() + "] (" + date + ") " + comment;
    }

    public String toString() {
        return this.getName();
    }

    public IResource getResource() {
        return null;
    }
}

