/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.processing;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.internal.core.search.processing.IJob;
import org.eclipse.jdt.internal.core.util.Util;

public abstract class JobManager
implements Runnable {
    protected IJob[] awaitingJobs = new IJob[10];
    protected int jobStart = 0;
    protected int jobEnd = -1;
    protected boolean executing = false;
    protected Thread processingThread;
    private int enableCount = 1;
    public static boolean VERBOSE = false;
    public boolean activated = false;
    private int awaitingClients = 0;

    public void activateProcessing() {
        this.activated = true;
    }

    public synchronized int awaitingJobsCount() {
        return this.activated ? this.jobEnd - this.jobStart + 1 : 1;
    }

    public synchronized IJob currentJob() {
        if (this.enableCount > 0 && this.jobStart <= this.jobEnd) {
            return this.awaitingJobs[this.jobStart];
        }
        return null;
    }

    public void disable() {
        --this.enableCount;
        if (VERBOSE) {
            Util.verbose("DISABLING background indexing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardJobs(String jobFamily) {
        if (VERBOSE) {
            Util.verbose("DISCARD   background job family - " + jobFamily);
        }
        try {
            IJob currentJob;
            JobManager jobManager = this;
            synchronized (jobManager) {
                currentJob = this.currentJob();
                this.disable();
            }
            if (currentJob != null && (jobFamily == null || currentJob.belongsTo(jobFamily))) {
                currentJob.cancel();
                while (this.processingThread != null && this.executing) {
                    try {
                        if (VERBOSE) {
                            Util.verbose("-> waiting end of current background job - " + currentJob);
                        }
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {}
                }
            }
            int loc = -1;
            JobManager jobManager2 = this;
            synchronized (jobManager2) {
                for (int i = this.jobStart; i <= this.jobEnd; ++i) {
                    currentJob = this.awaitingJobs[i];
                    if (currentJob == null) continue;
                    this.awaitingJobs[i] = null;
                    if (jobFamily != null && !currentJob.belongsTo(jobFamily)) {
                        this.awaitingJobs[++loc] = currentJob;
                        continue;
                    }
                    if (VERBOSE) {
                        Util.verbose("-> discarding background job  - " + currentJob);
                    }
                    currentJob.cancel();
                }
                this.jobStart = 0;
                this.jobEnd = loc;
            }
        }
        finally {
            this.enable();
        }
        if (VERBOSE) {
            Util.verbose("DISCARD   DONE with background job family - " + jobFamily);
        }
    }

    public synchronized void enable() {
        ++this.enableCount;
        if (VERBOSE) {
            Util.verbose("ENABLING  background indexing");
        }
        this.notifyAll();
    }

    protected synchronized void moveToNextJob() {
        if (this.jobStart <= this.jobEnd) {
            this.awaitingJobs[this.jobStart++] = null;
            if (this.jobStart > this.jobEnd) {
                this.jobStart = 0;
                this.jobEnd = -1;
            }
        }
    }

    protected void notifyIdle(long idlingTime) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performConcurrentJob(IJob searchJob, int waitingPolicy, IProgressMonitor progress) {
        boolean status;
        int concurrentJobWork;
        block39: {
            if (VERBOSE) {
                Util.verbose("STARTING  concurrent job - " + searchJob);
            }
            searchJob.ensureReadyToRun();
            concurrentJobWork = 100;
            if (progress != null) {
                progress.beginTask("", concurrentJobWork);
            }
            status = false;
            if (this.awaitingJobsCount() <= 0) break block39;
            switch (waitingPolicy) {
                case 1: {
                    if (VERBOSE) {
                        Util.verbose("-> NOT READY - forcing immediate - " + searchJob);
                    }
                    try {
                        this.disable();
                        status = searchJob.execute((IProgressMonitor)(progress == null ? null : new SubProgressMonitor(progress, concurrentJobWork)));
                    }
                    finally {
                        this.enable();
                    }
                    if (VERBOSE) {
                        Util.verbose("FINISHED  concurrent job - " + searchJob);
                    }
                    return status;
                }
                case 2: {
                    if (VERBOSE) {
                        Util.verbose("-> NOT READY - cancelling - " + searchJob);
                    }
                    if (progress != null) {
                        progress.setCanceled(true);
                    }
                    if (VERBOSE) {
                        Util.verbose("CANCELED concurrent job - " + searchJob);
                    }
                    throw new OperationCanceledException();
                }
                case 3: {
                    JobManager jobManager;
                    Thread t;
                    IJob previousJob = null;
                    SubProgressMonitor subProgress = null;
                    int totalWork = this.awaitingJobsCount();
                    if (progress != null && totalWork > 0) {
                        subProgress = new SubProgressMonitor(progress, concurrentJobWork / 2);
                        subProgress.beginTask("", totalWork);
                        concurrentJobWork /= 2;
                    }
                    int originalPriority = (t = this.processingThread) == null ? -1 : t.getPriority();
                    try {
                        int awaitingWork;
                        if (t != null) {
                            t.setPriority(Thread.currentThread().getPriority());
                        }
                        JobManager jobManager2 = this;
                        synchronized (jobManager2) {
                            ++this.awaitingClients;
                        }
                        while ((awaitingWork = this.awaitingJobsCount()) > 0) {
                            if (subProgress != null && subProgress.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            IJob currentJob = this.currentJob();
                            if (currentJob != null && currentJob != previousJob) {
                                if (VERBOSE) {
                                    Util.verbose("-> NOT READY - waiting until ready - " + searchJob);
                                }
                                if (subProgress != null) {
                                    subProgress.subTask(Util.bind("manager.filesToIndex", Integer.toString(awaitingWork)));
                                    subProgress.worked(1);
                                }
                                previousJob = currentJob;
                            }
                            try {
                                if (VERBOSE) {
                                    Util.verbose("-> GOING TO SLEEP - " + searchJob);
                                }
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException e) {}
                        }
                        Object var16_17 = null;
                        jobManager = this;
                    }
                    catch (Throwable throwable) {
                        Object var16_18 = null;
                        JobManager jobManager3 = this;
                        synchronized (jobManager3) {
                            --this.awaitingClients;
                        }
                        if (originalPriority > -1 && t.isAlive()) {
                            t.setPriority(originalPriority);
                        }
                        throw throwable;
                    }
                    synchronized (jobManager) {
                        --this.awaitingClients;
                    }
                    if (originalPriority > -1 && t.isAlive()) {
                        t.setPriority(originalPriority);
                    }
                    if (subProgress == null) break;
                    subProgress.done();
                }
            }
        }
        status = searchJob.execute((IProgressMonitor)(progress == null ? null : new SubProgressMonitor(progress, concurrentJobWork)));
        if (progress != null) {
            progress.done();
        }
        if (VERBOSE) {
            Util.verbose("FINISHED  concurrent job - " + searchJob);
        }
        return status;
    }

    public abstract String processName();

    public synchronized void request(IJob job) {
        job.ensureReadyToRun();
        int size = this.awaitingJobs.length;
        if (++this.jobEnd == size) {
            this.jobEnd -= this.jobStart;
            this.awaitingJobs = new IJob[size * 2];
            System.arraycopy(this.awaitingJobs, this.jobStart, this.awaitingJobs, 0, this.jobEnd);
            this.jobStart = 0;
        }
        this.awaitingJobs[this.jobEnd] = job;
        if (VERBOSE) {
            Util.verbose("REQUEST   background job - " + job);
            Util.verbose("AWAITING JOBS count: " + this.awaitingJobsCount());
        }
        this.notifyAll();
    }

    public synchronized void reset() {
        if (VERBOSE) {
            Util.verbose("Reset");
        }
        if (this.processingThread != null) {
            this.discardJobs(null);
        } else {
            this.processingThread = new Thread((Runnable)this, this.processName());
            this.processingThread.setDaemon(true);
            this.processingThread.setPriority(4);
            this.processingThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long idlingStart = -1L;
        this.activateProcessing();
        try {
            class ProgressJob
            extends Job {
                ProgressJob(String name) {
                    super(name);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    int awaitingJobsCount;
                    while ((awaitingJobsCount = JobManager.this.awaitingJobsCount()) > 0) {
                        monitor.subTask(Util.bind("manager.filesToIndex", Integer.toString(awaitingJobsCount)));
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    return Status.OK_STATUS;
                }
            }
            ProgressJob progressJob = null;
            while (this.processingThread != null) {
                try {
                    block24: {
                        Object var8_8;
                        IJob job;
                        JobManager jobManager = this;
                        synchronized (jobManager) {
                            if (this.processingThread == null) {
                                continue;
                            }
                            job = this.currentJob();
                            if (job == null) {
                                if (progressJob != null) {
                                    progressJob = null;
                                }
                                if (idlingStart < 0L) {
                                    idlingStart = System.currentTimeMillis();
                                } else {
                                    this.notifyIdle(System.currentTimeMillis() - idlingStart);
                                }
                                this.wait();
                            } else {
                                idlingStart = -1L;
                            }
                        }
                        if (job == null) {
                            this.notifyIdle(System.currentTimeMillis() - idlingStart);
                            Thread.sleep(500L);
                            continue;
                        }
                        if (VERBOSE) {
                            Util.verbose(this.awaitingJobsCount() + " awaiting jobs");
                            Util.verbose("STARTING background job - " + job);
                        }
                        try {
                            this.executing = true;
                            if (progressJob == null) {
                                progressJob = new ProgressJob(Util.bind("manager.indexingInProgress"));
                                progressJob.setPriority(30);
                                progressJob.setSystem(true);
                                progressJob.schedule();
                            }
                            job.execute(null);
                            var8_8 = null;
                            this.executing = false;
                            if (!VERBOSE) break block24;
                        }
                        catch (Throwable throwable) {
                            var8_8 = null;
                            this.executing = false;
                            if (VERBOSE) {
                                Util.verbose("FINISHED background job - " + job);
                            }
                            this.moveToNextJob();
                            if (this.awaitingClients == 0) {
                                Thread.sleep(50L);
                            }
                            throw throwable;
                        }
                        Util.verbose("FINISHED background job - " + job);
                    }
                    this.moveToNextJob();
                    if (this.awaitingClients != 0) continue;
                    Thread.sleep(50L);
                    {
                    }
                }
                catch (InterruptedException e) {
                }
            }
        }
        catch (RuntimeException e) {
            if (this.processingThread != null) {
                Util.log(e, "Background Indexer Crash Recovery");
                this.discardJobs(null);
                this.processingThread = null;
                this.reset();
            }
            throw e;
        }
        catch (Error e) {
            if (this.processingThread != null && !(e instanceof ThreadDeath)) {
                Util.log(e, "Background Indexer Crash Recovery");
                this.discardJobs(null);
                this.processingThread = null;
                this.reset();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        block6: {
            if (VERBOSE) {
                Util.verbose("Shutdown");
            }
            this.disable();
            this.discardJobs(null);
            Thread thread = this.processingThread;
            try {
                if (thread == null) break block6;
                JobManager jobManager = this;
                synchronized (jobManager) {
                    this.processingThread = null;
                    this.notifyAll();
                }
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(10);
        buffer.append("Enable count:").append(this.enableCount).append('\n');
        int numJobs = this.jobEnd - this.jobStart + 1;
        buffer.append("Jobs in queue:").append(numJobs).append('\n');
        for (int i = 0; i < numJobs && i < 15; ++i) {
            buffer.append(i).append(" - job[" + i + "]: ").append(this.awaitingJobs[this.jobStart + i]).append('\n');
        }
        return buffer.toString();
    }
}

