/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.internal.ActionDescriptor;
import org.eclipse.ui.internal.EditorActionBuilder;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.KeyBindingService;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PluginAction;
import org.eclipse.ui.internal.PopupMenuExtender;
import org.eclipse.ui.internal.progress.WorkbenchSiteProgressService;

public class PartSite
implements IWorkbenchPartSite {
    private IWorkbenchPartReference partReference;
    private IWorkbenchPart part;
    private IWorkbenchPage page;
    private PartPane pane;
    private IConfigurationElement configElement;
    private String extensionID;
    private String pluginID;
    private String extensionName;
    private ISelectionProvider selectionProvider;
    private SubActionBars actionBars;
    private KeyBindingService keyBindingService;
    private ArrayList menuExtenders;
    private WorkbenchSiteProgressService progressService;
    static /* synthetic */ Class class$org$eclipse$ui$progress$IWorkbenchSiteProgressService;

    public PartSite(IWorkbenchPartReference ref, IWorkbenchPart part, IWorkbenchPage page) {
        this.partReference = ref;
        this.part = part;
        this.page = page;
        this.extensionID = "org.eclipse.ui.UnknownID";
        this.extensionName = "Unknown Name";
    }

    public void dispose() {
        if (this.menuExtenders != null) {
            for (int i = 0; i < this.menuExtenders.size(); ++i) {
                ((PopupMenuExtender)this.menuExtenders.get(i)).dispose();
            }
            this.menuExtenders = null;
        }
        if (this.keyBindingService != null) {
            this.keyBindingService.dispose();
        }
        if (this.progressService != null) {
            this.progressService.dispose();
        }
    }

    public IActionBars getActionBars() {
        return this.actionBars;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configElement;
    }

    public String getId() {
        return this.extensionID;
    }

    public IWorkbenchPage getPage() {
        return this.page;
    }

    public PartPane getPane() {
        return this.pane;
    }

    public IWorkbenchPart getPart() {
        return this.part;
    }

    public IWorkbenchPartReference getPartReference() {
        return this.partReference;
    }

    public String getPluginId() {
        return this.pluginID;
    }

    public String getRegisteredName() {
        return this.extensionName;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public Shell getShell() {
        return this.page.getWorkbenchWindow().getShell();
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        return this.page.getWorkbenchWindow();
    }

    public void registerContextMenu(String menuID, MenuManager menuMgr, ISelectionProvider selProvider) {
        if (this.menuExtenders == null) {
            this.menuExtenders = new ArrayList(1);
        }
        this.menuExtenders.add(new PopupMenuExtender(menuID, menuMgr, selProvider, this.part));
    }

    public void registerContextMenu(MenuManager menuMgr, ISelectionProvider selProvider) {
        this.registerContextMenu(this.getId(), menuMgr, selProvider);
    }

    public String[] getContextMenuIds() {
        if (this.menuExtenders == null) {
            return new String[0];
        }
        String[] menuIds = new String[this.menuExtenders.size()];
        int index = 0;
        Iterator iter = this.menuExtenders.iterator();
        while (iter.hasNext()) {
            menuIds[index++] = ((PopupMenuExtender)iter.next()).getMenuId();
        }
        return menuIds;
    }

    public void setActionBars(SubActionBars bars) {
        this.actionBars = bars;
    }

    public void setConfigurationElement(IConfigurationElement configElement) {
        this.configElement = configElement;
        this.extensionID = configElement.getAttribute("id");
        this.pluginID = configElement.getDeclaringExtension().getNamespace();
        String name = configElement.getAttribute("name");
        if (name != null) {
            this.extensionName = name;
        }
    }

    protected void setId(String id) {
        this.extensionID = id;
    }

    public void setPane(PartPane pane) {
        this.pane = pane;
    }

    public void setPart(IWorkbenchPart newPart) {
        this.part = newPart;
    }

    protected void setRegisteredName(String name) {
        this.extensionName = name;
    }

    public void setSelectionProvider(ISelectionProvider provider) {
        this.selectionProvider = provider;
    }

    public IKeyBindingService getKeyBindingService() {
        if (this.keyBindingService == null) {
            ActionDescriptor[] actionDescriptors;
            EditorActionBuilder.ExternalContributor contributor;
            this.keyBindingService = new KeyBindingService(this);
            if (this instanceof EditorSite && (contributor = (EditorActionBuilder.ExternalContributor)((EditorSite)this).getExtensionActionBarContributor()) != null && (actionDescriptors = contributor.getExtendedActions()) != null) {
                for (int i = 0; i < actionDescriptors.length; ++i) {
                    PluginAction action;
                    ActionDescriptor actionDescriptor = actionDescriptors[i];
                    if (actionDescriptor == null || (action = actionDescriptors[i].getAction()) == null || action.getActionDefinitionId() == null) continue;
                    this.keyBindingService.registerAction((IAction)action);
                }
            }
        }
        return this.keyBindingService;
    }

    protected String getInitialScopeId() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        if ((class$org$eclipse$ui$progress$IWorkbenchSiteProgressService == null ? (class$org$eclipse$ui$progress$IWorkbenchSiteProgressService = PartSite.class$("org.eclipse.ui.progress.IWorkbenchSiteProgressService")) : class$org$eclipse$ui$progress$IWorkbenchSiteProgressService).equals(adapter)) {
            return this.getSiteProgressService();
        }
        return null;
    }

    private WorkbenchSiteProgressService getSiteProgressService() {
        if (this.progressService == null) {
            this.progressService = new WorkbenchSiteProgressService(this);
        }
        return this.progressService;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

