/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.breakpoints;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaClassPrepareBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ToggleClassPrepareBreakpointAction
implements IObjectActionDelegate,
IActionDelegate2 {
    private ISelection selection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void init(IAction action) {
    }

    public void dispose() {
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void run(IAction action) {
        IStructuredSelection ss = (IStructuredSelection)this.selection;
        Iterator iterator = ss.iterator();
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(JDIDebugModel.getPluginIdentifier());
        while (iterator.hasNext()) {
            IType type = (IType)iterator.next();
            IJavaBreakpoint existing = null;
            try {
                for (int i = 0; i < breakpoints.length; ++i) {
                    IJavaBreakpoint breakpoint = (IJavaBreakpoint)breakpoints[i];
                    if (!(breakpoint instanceof IJavaClassPrepareBreakpoint) || !type.getFullyQualifiedName().equals(breakpoint.getTypeName())) continue;
                    existing = breakpoint;
                    break;
                }
                if (existing != null) {
                    existing.delete();
                    continue;
                }
                int kind = 0;
                if (!type.isClass()) {
                    kind = 1;
                }
                HashMap map = new HashMap(10);
                BreakpointUtils.addJavaBreakpointAttributes(map, (IJavaElement)type);
                ISourceRange range = type.getNameRange();
                int start = -1;
                int end = -1;
                if (range != null) {
                    start = range.getOffset();
                    end = start + range.getLength();
                }
                JDIDebugModel.createClassPrepareBreakpoint((IResource)BreakpointUtils.getBreakpointResource((IMember)type), (String)type.getFullyQualifiedName(), (int)kind, (int)start, (int)end, (boolean)true, map);
            }
            catch (CoreException e) {}
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
}

