/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.model;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.SiteFeatureReference;
import org.eclipse.update.core.model.FeatureReferenceModel;
import org.eclipse.update.core.model.ModelObject;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.ConfiguredSiteModel;

public class ConfigurationPolicyModel
extends ModelObject {
    private int policy;
    private Map configuredFeatureReferences = new HashMap();
    private Map unconfiguredFeatureReferences;
    private ConfiguredSiteModel configuredSiteModel;
    private boolean enable = true;

    public int getPolicy() {
        return this.policy;
    }

    public void setPolicy(int policy) {
        this.assertIsWriteable();
        this.policy = policy;
    }

    public FeatureReferenceModel[] getConfiguredFeaturesModel() {
        if (this.configuredFeatureReferences == null || this.configuredFeatureReferences.isEmpty()) {
            return new FeatureReferenceModel[0];
        }
        return (FeatureReferenceModel[])this.configuredFeatureReferences.keySet().toArray(this.arrayTypeFor(this.configuredFeatureReferences.keySet()));
    }

    public FeatureReferenceModel[] getUnconfiguredFeaturesModel() {
        ISite site;
        ISiteFeatureReference[] siteFeatures;
        if (this.unconfiguredFeatureReferences == null && this.configuredSiteModel != null && this.configuredSiteModel.getSiteModel() != null && (siteFeatures = (site = (ISite)((Object)this.configuredSiteModel.getSiteModel())).getFeatureReferences()).length > this.getConfiguredFeaturesModel().length) {
            for (int i = 0; i < siteFeatures.length; ++i) {
                if (!(siteFeatures[i] instanceof SiteFeatureReference)) continue;
                Iterator iterator = this.configuredFeatureReferences.keySet().iterator();
                boolean found = false;
                while (!found && iterator.hasNext()) {
                    FeatureReferenceModel f = (FeatureReferenceModel)((Object)iterator.next());
                    if (!UpdateManagerUtils.sameURL(f.getURL(), siteFeatures[i].getURL())) continue;
                    found = true;
                }
                if (found) continue;
                this.addUnconfiguredFeatureReference((SiteFeatureReference)siteFeatures[i]);
            }
        }
        if (this.unconfiguredFeatureReferences == null || this.unconfiguredFeatureReferences.isEmpty()) {
            return new FeatureReferenceModel[0];
        }
        return (FeatureReferenceModel[])this.unconfiguredFeatureReferences.keySet().toArray(this.arrayTypeFor(this.unconfiguredFeatureReferences.keySet()));
    }

    public ConfiguredSiteModel getConfiguredSiteModel() {
        return this.configuredSiteModel;
    }

    public void setConfiguredSiteModel(ConfiguredSiteModel configuredSiteModel) {
        this.configuredSiteModel = configuredSiteModel;
    }

    private boolean remove(FeatureReferenceModel feature, Map list) {
        URL featureURL = feature.getURL();
        boolean found = false;
        Iterator iter = list.keySet().iterator();
        while (iter.hasNext() && !found) {
            FeatureReferenceModel element = (FeatureReferenceModel)((Object)iter.next());
            if (!UpdateManagerUtils.sameURL(element.getURL(), featureURL)) continue;
            list.remove((Object)element);
            found = true;
        }
        return found;
    }

    private void add(FeatureReferenceModel feature, Map list) {
        URL featureURL = feature.getURL();
        boolean found = false;
        Iterator iter = list.keySet().iterator();
        while (iter.hasNext() && !found) {
            FeatureReferenceModel element = (FeatureReferenceModel)((Object)iter.next());
            if (!UpdateManagerUtils.sameURL(element.getURL(), featureURL)) continue;
            found = true;
        }
        if (!found) {
            list.put(feature, null);
        } else {
            UpdateCore.warn("Feature Reference :" + (Object)((Object)feature) + " already part of the list.");
        }
    }

    public void addConfiguredFeatureReference(FeatureReferenceModel feature) {
        boolean success;
        this.assertIsWriteable();
        if (this.configuredFeatureReferences == null) {
            this.configuredFeatureReferences = new HashMap();
        }
        if (!this.configuredFeatureReferences.containsKey((Object)feature)) {
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
                UpdateCore.debug("Configuring " + feature.getURLString());
            }
            this.add(feature, this.configuredFeatureReferences);
        }
        if (this.unconfiguredFeatureReferences != null && !(success = this.remove(feature, this.unconfiguredFeatureReferences))) {
            UpdateCore.warn("Feature not part of Unconfigured list: " + feature.getURLString());
        }
    }

    public void addUnconfiguredFeatureReference(FeatureReferenceModel feature) {
        boolean success;
        this.assertIsWriteable();
        if (this.unconfiguredFeatureReferences == null) {
            this.unconfiguredFeatureReferences = new HashMap();
        }
        if (!this.unconfiguredFeatureReferences.containsKey((Object)feature)) {
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
                UpdateCore.debug("Unconfiguring " + feature.getURLString());
            }
            this.add(feature, this.unconfiguredFeatureReferences);
        }
        if (this.configuredFeatureReferences != null && !(success = this.remove(feature, this.configuredFeatureReferences))) {
            UpdateCore.warn("Feature not part of Configured list: " + feature.getURLString());
        }
    }

    public void removeFeatureReference(FeatureReferenceModel feature) {
        boolean success;
        this.assertIsWriteable();
        if (this.unconfiguredFeatureReferences != null && !(success = this.remove(feature, this.unconfiguredFeatureReferences))) {
            UpdateCore.warn(feature.getURLString() + " not part of unconfigured list.");
        }
        if (this.configuredFeatureReferences != null && !(success = this.remove(feature, this.configuredFeatureReferences))) {
            UpdateCore.warn(feature.getURLString() + " not part of configured list.");
        }
    }

    protected void setUnconfiguredFeatureReferences(IFeatureReference[] featureReferences) {
        this.unconfiguredFeatureReferences = new HashMap();
        for (int i = 0; i < featureReferences.length; ++i) {
            this.unconfiguredFeatureReferences.put(featureReferences[i], null);
        }
    }

    protected void setConfiguredFeatureReferences(IFeatureReference[] featureReferences) {
        this.configuredFeatureReferences = new HashMap();
        for (int i = 0; i < featureReferences.length; ++i) {
            this.configuredFeatureReferences.put(featureReferences[i], null);
        }
    }

    public boolean isEnabled() {
        return this.enable;
    }

    public void setEnabled(boolean value) {
        this.enable = value;
    }
}

