/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.plugin.MatchSection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class FeatureMatchSection
extends MatchSection {
    private Button patchButton;

    public FeatureMatchSection(PDEFormPage formPage, Composite parent) {
        super(formPage, parent, false);
    }

    public void createClient(Section section, FormToolkit toolkit) {
        super.createClient(section, toolkit);
        Composite client = (Composite)section.getClient();
        this.patchButton = toolkit.createButton(client, PDEPlugin.getResourceString("FeatureMatchSection.patch"), 32);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.patchButton.setLayoutData((Object)gd);
        this.patchButton.setEnabled(false);
        this.patchButton.setSelection(false);
        this.patchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureMatchSection.this.handlePatchChange(FeatureMatchSection.this.patchButton.getSelection());
            }
        });
    }

    private void handlePatchChange(boolean patch) {
        IFeatureImport iimport;
        if (this.currentImport != null && (iimport = (IFeatureImport)this.currentImport).getType() == 1) {
            try {
                iimport.setPatch(patch);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
        if (this.multiSelection != null) {
            Iterator iter = this.multiSelection.iterator();
            while (iter.hasNext()) {
                IFeatureImport iimport2 = (IFeatureImport)iter.next();
                try {
                    iimport2.setPatch(patch);
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                    break;
                }
            }
        }
    }

    protected void update(IStructuredSelection selection) {
        super.update(selection);
        if (this.patchButton == null) {
            return;
        }
        if (selection.isEmpty()) {
            this.update((IPluginReference)((IFeatureImport)null));
            return;
        }
        if (!(selection.getFirstElement() instanceof IFeatureImport)) {
            return;
        }
        if (selection.size() == 1) {
            this.update((IPluginReference)((IFeatureImport)selection.getFirstElement()));
            return;
        }
        int ntrue = 0;
        int nfalse = 0;
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            IFeatureImport iimport = (IFeatureImport)iter.next();
            if (iimport.getType() != 1) continue;
            if (iimport.isPatch()) {
                ++ntrue;
                continue;
            }
            ++nfalse;
        }
        this.patchButton.setEnabled(this.isEditable() && (ntrue > 0 || nfalse > 0));
        this.patchButton.setSelection(ntrue > 0);
    }

    protected void update(IPluginReference reference) {
        super.update(reference);
        if (this.patchButton == null) {
            return;
        }
        IFeatureImport fimport = (IFeatureImport)reference;
        if (fimport == null || fimport.getType() == 0) {
            this.patchButton.setSelection(false);
            this.patchButton.setEnabled(false);
            return;
        }
        this.patchButton.setEnabled(this.getPage().getModel().isEditable());
        this.patchButton.setSelection(fimport.isPatch());
    }
}

