/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.search.JavaSearchCollector;

class JavaSearchOperation
implements IWorkspaceRunnable,
IRunnableWithProgress {
    IJavaElement element;
    IProject parentProject;
    private static final String KEY_MATCH = "Search.singleMatch";
    private static final String KEY_MATCHES = "Search.multipleMatches";

    public JavaSearchOperation(IJavaElement element, IProject parentProject) {
        this.element = element;
        this.parentProject = parentProject;
    }

    public void run(IProgressMonitor monitor) {
        this.doJavaSearch(monitor);
    }

    private void doJavaSearch(IProgressMonitor monitor) {
        try {
            SearchEngine searchEngine = new SearchEngine();
            searchEngine.search(PDEPlugin.getWorkspace(), this.element, 2, this.getSearchScope(), (IJavaSearchResultCollector)new JavaSearchCollector(this, monitor));
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    private IJavaSearchScope getSearchScope() throws JavaModelException {
        IPackageFragmentRoot[] roots = JavaCore.create((IProject)this.parentProject).getPackageFragmentRoots();
        ArrayList<IPackageFragmentRoot> filteredRoots = new ArrayList<IPackageFragmentRoot>();
        for (int i = 0; i < roots.length; ++i) {
            if (roots[i].getResource() == null || !roots[i].getResource().getProject().equals(this.parentProject)) continue;
            filteredRoots.add(roots[i]);
        }
        return SearchEngine.createJavaSearchScope((IJavaElement[])filteredRoots.toArray(new IJavaElement[filteredRoots.size()]));
    }

    public String getPluralLabel() {
        return this.element.getElementName() + " - {0} " + PDEPlugin.getResourceString(KEY_MATCHES);
    }

    public String getSingularLabel() {
        return this.element.getElementName() + " - 1 " + PDEPlugin.getResourceString(KEY_MATCH);
    }
}

