/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.ISearchResultPage;

public class SearchPageRegistry {
    private Map fClassToInstance;
    private Map fTargetClassNameToExtension;
    private Map fExtensionToInstance = new HashMap();
    private String fIdAttribute;

    public SearchPageRegistry(String extensionPoint, String targetClassAttribute, String idAttribute) {
        this.fClassToInstance = new HashMap();
        this.initializeExtensionCache(extensionPoint, targetClassAttribute);
        this.fIdAttribute = idAttribute;
    }

    private void initializeExtensionCache(String extensionPoint, String targetClassAttribute) {
        this.fTargetClassNameToExtension = new HashMap();
        IConfigurationElement[] extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionPoint);
        for (int i = 0; i < extensions.length; ++i) {
            this.fTargetClassNameToExtension.put(extensions[i].getAttribute(targetClassAttribute), extensions[i]);
        }
    }

    public ISearchResultPage getExtensionObject(Object element, Class expectedType) {
        ISearchResultPage page = (ISearchResultPage)this.fClassToInstance.get(element.getClass());
        if (page != null) {
            return page;
        }
        if (this.fClassToInstance.containsKey(element.getClass())) {
            return null;
        }
        page = this.internalGetExtensionObject(element, expectedType);
        if (page != null) {
            this.fClassToInstance.put(element.getClass(), page);
        }
        return page;
    }

    private ISearchResultPage internalGetExtensionObject(Object element, Class expectedType) {
        IConfigurationElement configElement = (IConfigurationElement)this.fTargetClassNameToExtension.get(element.getClass().getName());
        if (configElement == null) {
            if (this.fTargetClassNameToExtension.containsKey(element.getClass().getName())) {
                return null;
            }
            configElement = this.getConfigElement(element.getClass());
            if (configElement != null) {
                this.fTargetClassNameToExtension.put(element.getClass().getName(), configElement);
            }
        }
        if (configElement != null) {
            ISearchResultPage lp = (ISearchResultPage)this.fExtensionToInstance.get(configElement);
            if (lp == null) {
                if (this.fExtensionToInstance.containsKey(configElement)) {
                    return null;
                }
                try {
                    ISearchResultPage instance = (ISearchResultPage)configElement.createExecutableExtension("class");
                    String id = configElement.getAttribute(this.fIdAttribute);
                    instance.setID(id);
                    if (expectedType.isAssignableFrom(instance.getClass())) {
                        this.fExtensionToInstance.put(configElement, instance);
                        return instance;
                    }
                }
                catch (CoreException e) {
                    SearchPlugin.getDefault().getLog().log(e.getStatus());
                }
            } else {
                return lp;
            }
        }
        return null;
    }

    private IConfigurationElement getConfigElement(Class clazz) {
        return this.searchInSupertypes(clazz);
    }

    private IConfigurationElement searchInSupertypes(Class clazz) {
        int i;
        IConfigurationElement foundExtension = null;
        Class superclass = clazz.getSuperclass();
        if (superclass != null) {
            foundExtension = (IConfigurationElement)this.fTargetClassNameToExtension.get(superclass.getName());
        }
        if (foundExtension != null) {
            return foundExtension;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (i = 0; i < interfaces.length; ++i) {
            foundExtension = (IConfigurationElement)this.fTargetClassNameToExtension.get(interfaces[i].getName());
            if (foundExtension == null) continue;
            return foundExtension;
        }
        if (superclass != null) {
            foundExtension = this.searchInSupertypes(superclass);
        }
        if (foundExtension != null) {
            return foundExtension;
        }
        for (i = 0; i < interfaces.length; ++i) {
            foundExtension = this.searchInSupertypes(interfaces[i]);
            if (foundExtension == null) continue;
            return foundExtension;
        }
        return null;
    }
}

