/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.AbstractJavaElementRenameChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class RenameJavaProjectChange
extends AbstractJavaElementRenameChange {
    private boolean fUpdateReferences;

    public RenameJavaProjectChange(IJavaProject project, String newName, boolean updateReferences) throws JavaModelException {
        this(project.getPath(), project.getElementName(), newName);
        Assert.isTrue(!project.isReadOnly(), "should not be read only");
        this.fUpdateReferences = updateReferences;
    }

    private RenameJavaProjectChange(IPath resourcePath, String oldName, String newName) {
        super(resourcePath, oldName, newName);
    }

    public String getName() {
        return RefactoringCoreMessages.getFormattedString("RenameJavaProjectChange.rename", new String[]{this.getOldName(), this.getNewName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        if (!this.getJavaProject().exists()) {
            return result;
        }
        try {
            IPackageFragmentRoot[] roots = this.getJavaProject().getPackageFragmentRoots();
            if (roots.length == 0) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.beginTask("", roots.length);
            for (int i = 0; i < roots.length; ++i) {
                result.merge(RenameJavaProjectChange.checkIfModifiable(roots[i], (IProgressMonitor)new SubProgressMonitor(pm, 1)));
            }
        }
        finally {
            pm.done();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRename(IProgressMonitor pm) throws CoreException {
        try {
            IProject project;
            pm.beginTask(this.getName(), 2);
            if (this.fUpdateReferences) {
                this.modifyClassPaths((IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
            if ((project = this.getProject()) != null) {
                IProjectDescription description = project.getDescription();
                description.setName(this.createNewPath().segment(0));
                project.move(description, 33, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
        }
        finally {
            pm.done();
        }
    }

    protected Change createUndoChange() throws JavaModelException {
        return new RenameJavaProjectChange(this.createNewPath(), this.getNewName(), this.getOldName());
    }

    private IProject getProject() {
        IJavaProject jp = this.getJavaProject();
        if (jp == null) {
            return null;
        }
        return jp.getProject();
    }

    private IJavaProject getJavaProject() {
        return (IJavaProject)this.getModifiedElement();
    }

    private void modifyClassPaths(IProgressMonitor pm) throws JavaModelException {
        IProject[] referencing = this.getReferencingProjects();
        pm.beginTask(RefactoringCoreMessages.getString("RenameJavaProjectChange.update"), referencing.length);
        for (int i = 0; i < referencing.length; ++i) {
            IJavaProject jp = JavaCore.create((IProject)referencing[i]);
            if (jp != null && jp.exists()) {
                this.modifyClassPath(jp, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                continue;
            }
            pm.worked(1);
        }
        pm.done();
    }

    private void modifyClassPath(IJavaProject referencingProject, IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 1);
        IClasspathEntry[] oldEntries = referencingProject.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length];
        for (int i = 0; i < newEntries.length; ++i) {
            newEntries[i] = this.isOurEntry(oldEntries[i]) ? this.createModifiedEntry() : oldEntries[i];
        }
        referencingProject.setRawClasspath(newEntries, pm);
        pm.done();
    }

    private boolean isOurEntry(IClasspathEntry cpe) {
        if (cpe.getEntryKind() != 2) {
            return false;
        }
        return cpe.getPath().equals(this.getResourcePath());
    }

    private IClasspathEntry createModifiedEntry() {
        return JavaCore.newProjectEntry((IPath)this.createNewPath());
    }

    private IProject[] getReferencingProjects() {
        return this.getProject().getReferencingProjects();
    }

    private IPath createNewPath() {
        return this.getResourcePath().removeLastSegments(1).append(this.getNewName());
    }
}

