/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.CreateTextFileChange;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ltk.core.refactoring.Change;

class AccessorClass {
    private final ICompilationUnit fCu;
    private final String fAccessorClassName;
    private final IPath fAccessorPath;
    private final IPath fResourceBundlePath;
    private final IPackageFragment fAccessorPackage;
    private static String lineDelim = System.getProperty("line.separator", "\n");

    private AccessorClass(ICompilationUnit cu, String accessorClassname, IPath accessorPath, IPackageFragment accessorPackage, IPath resourceBundlePath) {
        this.fCu = cu;
        this.fAccessorClassName = accessorClassname;
        this.fAccessorPath = accessorPath;
        this.fAccessorPackage = accessorPackage;
        this.fResourceBundlePath = resourceBundlePath;
    }

    public static Change create(ICompilationUnit cu, String accessorClassname, IPath accessorPath, IPackageFragment accessorPackage, IPath resourceBundlePath, IProgressMonitor pm) throws CoreException {
        AccessorClass accessorClass = new AccessorClass(cu, accessorClassname, accessorPath, accessorPackage, resourceBundlePath);
        return new CreateTextFileChange(accessorPath, accessorClass.createAccessorCUSource(pm), null, "java");
    }

    private String createAccessorCUSource(IProgressMonitor pm) throws CoreException {
        return CodeFormatterUtil.format(8, this.getUnformattedSource(pm), 0, null, null, this.fCu.getJavaProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUnformattedSource(IProgressMonitor pm) throws CoreException {
        ICompilationUnit newCu = null;
        try {
            newCu = WorkingCopyUtil.getNewWorkingCopy(this.fAccessorPackage, this.fAccessorPath.lastSegment());
            String comment = CodeGeneration.getTypeComment(newCu, this.fAccessorClassName, lineDelim);
            String classContent = this.createClass();
            String cuContent = CodeGeneration.getCompilationUnitContent(newCu, comment, classContent, lineDelim);
            if (cuContent == null) {
                StringBuffer buf = new StringBuffer();
                if (!this.fAccessorPackage.isDefaultPackage()) {
                    buf.append("package ").append(this.fAccessorPackage.getElementName()).append(';');
                }
                buf.append(lineDelim).append(lineDelim);
                if (comment != null) {
                    buf.append(comment).append(lineDelim);
                }
                buf.append(classContent);
                cuContent = buf.toString();
            }
            newCu.getBuffer().setContents(cuContent);
            this.addImportsToAccessorCu(newCu, pm);
            String string = newCu.getSource();
            return string;
        }
        finally {
            if (newCu != null) {
                newCu.discardWorkingCopy();
            }
        }
    }

    private void addImportsToAccessorCu(ICompilationUnit newCu, IProgressMonitor pm) throws CoreException {
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        String[] order = JavaPreferencesSettings.getImportOrderPreference(store);
        int importThreshold = JavaPreferencesSettings.getImportNumberThreshold(store);
        ImportsStructure is = new ImportsStructure(newCu, order, importThreshold, true);
        is.addImport("java.util.MissingResourceException");
        is.addImport("java.util.ResourceBundle");
        is.create(false, pm);
    }

    private String createClass() throws CoreException {
        String ld = lineDelim;
        return "public class " + this.fAccessorClassName + " {" + "private static final String " + "BUNDLE_NAME" + " = \"" + this.getResourceBundleName() + "\";" + NLSElement.createTagText(1) + ld + ld + "private static final ResourceBundle " + this.getResourceBundleConstantName() + "= ResourceBundle.getBundle(" + "BUNDLE_NAME" + ");" + ld + ld + this.createConstructor() + ld + this.createGetStringMethod() + ld + "}" + ld;
    }

    private String getResourceBundleConstantName() {
        return "RESOURCE_BUNDLE";
    }

    private String createGetStringMethod() throws CoreException {
        String bodyStatement = "try {" + lineDelim + "return " + this.getResourceBundleConstantName() + ".getString(key);" + lineDelim + "} catch (MissingResourceException e) {" + lineDelim + "return '!' + key + '!';" + lineDelim + "}";
        String methodBody = CodeGeneration.getMethodBodyContent(this.fCu, this.fAccessorClassName, "getString", false, bodyStatement, lineDelim);
        if (methodBody == null) {
            methodBody = "";
        }
        return "public static String getString(String key) {" + lineDelim + methodBody + lineDelim + '}';
    }

    private String createConstructor() {
        return "private " + this.fAccessorClassName + "(){" + lineDelim + '}';
    }

    private String getPropertyFileName() {
        return this.fResourceBundlePath.lastSegment();
    }

    private String getPropertyFileNameWithoutExtension() {
        String fileName = this.getPropertyFileName();
        return fileName.substring(0, fileName.indexOf(".properties"));
    }

    private String getResourceBundleName() throws CoreException {
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(this.fResourceBundlePath.removeLastSegments(1));
        if (res != null && res.exists()) {
            IJavaElement el = JavaCore.create((IResource)res);
            if (el instanceof IPackageFragment) {
                IPackageFragment p = (IPackageFragment)el;
                return p.getElementName() + '.' + this.getPropertyFileNameWithoutExtension();
            }
            if (el instanceof IPackageFragmentRoot || el instanceof IJavaProject) {
                return this.getPropertyFileNameWithoutExtension();
            }
        }
        throw new CoreException((IStatus)new StatusInfo(4, "Resourcebundle not specified"));
    }
}

