/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.HashSet;
import org.eclipse.jdt.core.CompletionRequestorAdapter;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ICompletionRequestor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.TypeFilter;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.NameMatcher;
import org.eclipse.jdt.internal.ui.text.correction.SimilarElement;

public class SimilarElementsRequestor
extends CompletionRequestorAdapter {
    public static final int CLASSES = 2;
    public static final int INTERFACES = 4;
    public static final int PRIMITIVETYPES = 8;
    public static final int VOIDTYPE = 16;
    public static final int REF_TYPES = 6;
    public static final int ALL_TYPES = 14;
    public static final int METHODS = 32;
    public static final int FIELDS = 64;
    public static final int LOCALS = 128;
    public static final int VARIABLES = 192;
    private static final String[] PRIM_TYPES = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"};
    private String fPreferredType;
    private int fNumberOfArguments;
    private int fKind;
    private String fName;
    private HashSet fResult;
    private HashSet fOthers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimilarElement[] findSimilarElement(ICompilationUnit cu, Name name, int kind) throws JavaModelException {
        int pos = name.getStartPosition();
        int nArguments = -1;
        String identifier = ASTNodes.getSimpleNameIdentifier(name);
        String returnType = null;
        ICompilationUnit preparedCU = null;
        if ((kind & 6) != 0) {
            pos = name.isQualifiedName() ? ((QualifiedName)name).getName().getStartPosition() : name.getStartPosition() + 1;
            Javadoc javadoc = (Javadoc)ASTNodes.getParent((ASTNode)name, 29);
            if (javadoc != null) {
                cu = preparedCU = SimilarElementsRequestor.createPreparedCU(cu, javadoc, name.getStartPosition());
            }
        } else {
            ITypeBinding binding;
            if (name.getParent().getNodeType() == 32) {
                MethodInvocation invocation = (MethodInvocation)name.getParent();
                if (name.equals((Object)invocation.getName())) {
                    if ((kind & 0x20) != 0) {
                        nArguments = invocation.arguments().size();
                    }
                } else if (invocation.arguments().contains(name)) {
                    pos = invocation.getStartPosition();
                }
            }
            if ((binding = ASTResolving.guessBindingForReference((ASTNode)name)) != null) {
                returnType = binding.getName();
            }
        }
        try {
            SimilarElementsRequestor requestor = new SimilarElementsRequestor(identifier, kind, nArguments, returnType);
            SimilarElement[] similarElementArray = requestor.process(cu, pos);
            return similarElementArray;
        }
        finally {
            if (preparedCU != null) {
                preparedCU.discardWorkingCopy();
            }
        }
    }

    private static ICompilationUnit createPreparedCU(ICompilationUnit cu, Javadoc comment, int wordStart) throws JavaModelException {
        int startpos = comment.getStartPosition();
        boolean isTopLevel = comment.getParent().getParent() instanceof CompilationUnit;
        char[] content = (char[])cu.getBuffer().getCharacters().clone();
        if (isTopLevel && wordStart + 6 < content.length) {
            content[startpos++] = 105;
            content[startpos++] = 109;
            content[startpos++] = 112;
            content[startpos++] = 111;
            content[startpos++] = 114;
            content[startpos++] = 116;
        }
        if (wordStart < content.length) {
            for (int i = startpos; i < wordStart; ++i) {
                content[i] = 32;
            }
        }
        ICompilationUnit newCU = cu.getWorkingCopy(null);
        newCU.getBuffer().setContents(content);
        return newCU;
    }

    private SimilarElementsRequestor(String name, int kind, int nArguments, String preferredType) {
        this.fName = name;
        this.fKind = kind;
        this.fNumberOfArguments = nArguments;
        this.fPreferredType = preferredType;
        this.fResult = new HashSet();
        this.fOthers = new HashSet();
    }

    private void addResult(SimilarElement elem) {
        this.fResult.add(elem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimilarElement[] process(ICompilationUnit cu, int pos) throws JavaModelException {
        try {
            cu.codeComplete(pos, (ICompletionRequestor)this);
            this.processKeywords();
            if (this.fResult.size() == 0 && this.fOthers.size() < 6) {
                this.fResult = this.fOthers;
            }
            SimilarElement[] similarElementArray = this.fResult.toArray(new SimilarElement[this.fResult.size()]);
            return similarElementArray;
        }
        finally {
            this.fResult.clear();
            this.fOthers.clear();
        }
    }

    private void processKeywords() {
        String voidType;
        if ((this.fKind & 8) != 0) {
            for (int i = 0; i < PRIM_TYPES.length; ++i) {
                if (!NameMatcher.isSimilarName(this.fName, PRIM_TYPES[i])) continue;
                this.addResult(new SimilarElement(8, PRIM_TYPES[i], 50));
            }
        }
        if ((this.fKind & 0x10) != 0 && NameMatcher.isSimilarName(this.fName, voidType = "void")) {
            this.addResult(new SimilarElement(8, voidType, 50));
        }
    }

    private void addType(int kind, char[] packageName, char[] typeName, char[] completionName, int relevance) {
        if (TypeFilter.isFiltered(packageName)) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        if (packageName.length > 0) {
            buf.append(packageName);
            buf.append('.');
        }
        buf.append(typeName);
        SimilarElement elem = new SimilarElement(kind, buf.toString(), relevance);
        if (NameMatcher.isSimilarName(this.fName, new String(typeName))) {
            this.addResult(elem);
        }
    }

    private void addVariable(int kind, char[] name, char[] typePackageName, char[] typeName, int relevance) {
        if (TypeFilter.isFiltered(typePackageName)) {
            return;
        }
        String variableName = new String(name);
        if (NameMatcher.isSimilarName(this.fName, variableName)) {
            this.addResult(new SimilarElement(kind, variableName, 1));
        } else if (this.fPreferredType != null && this.fPreferredType.equals(JavaModelUtil.concatenateName(typePackageName, typeName))) {
            this.addResult(new SimilarElement(kind, variableName, 0));
        }
    }

    public void acceptClass(char[] packageName, char[] className, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
        if ((this.fKind & 2) != 0) {
            this.addType(2, packageName, className, completionName, relevance);
        }
    }

    public void acceptInterface(char[] packageName, char[] interfaceName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
        if ((this.fKind & 4) != 0) {
            this.addType(4, packageName, interfaceName, completionName, relevance);
        }
    }

    public void acceptField(char[] declaringTypePackageName, char[] declaringTypeName, char[] name, char[] typePackageName, char[] typeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
        if ((this.fKind & 0x40) != 0) {
            this.addVariable(64, name, typePackageName, typeName, relevance);
        }
    }

    public void acceptLocalVariable(char[] name, char[] typePackageName, char[] typeName, int modifiers, int completionStart, int completionEnd, int relevance) {
        if ((this.fKind & 0xC0) != 0) {
            this.addVariable(192, name, typePackageName, typeName, relevance);
        }
    }

    public void acceptMethod(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] returnTypePackageName, char[] returnTypeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
        if ((this.fKind & 0x20) != 0) {
            int similarity;
            if (TypeFilter.isFiltered(declaringTypePackageName)) {
                return;
            }
            String methodName = new String(selector);
            if (this.fName.equals(methodName)) {
                String[] paramTypes = new String[parameterTypeNames.length];
                for (int i = 0; i < paramTypes.length; ++i) {
                    paramTypes[i] = JavaModelUtil.concatenateName(parameterPackageNames[i], parameterTypeNames[i]);
                }
                this.addResult(new SimilarElement(32, methodName, paramTypes, relevance));
            } else if ((this.fNumberOfArguments == -1 || this.fNumberOfArguments == parameterTypeNames.length) && (similarity = NameMatcher.getSimilarity(this.fName, methodName)) >= 0) {
                SimilarElement elem = new SimilarElement(32, methodName, null, relevance + similarity);
                this.addResult(elem);
            }
        }
    }
}

