/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.util.OpenTypeHierarchyUtil;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class OpenTypeHierarchyAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public OpenTypeHierarchyAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.getString("OpenTypeHierarchyAction.label"));
        this.setToolTipText(ActionMessages.getString("OpenTypeHierarchyAction.tooltip"));
        this.setDescription(ActionMessages.getString("OpenTypeHierarchyAction.description"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.open_type_hierarchy_action");
    }

    public OpenTypeHierarchyAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.isEnabled(selection));
    }

    private boolean isEnabled(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        Object input = selection.getFirstElement();
        if (!(input instanceof IJavaElement)) {
            return false;
        }
        switch (((IJavaElement)input).getElementType()) {
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    public void run(ITextSelection selection) {
        IJavaElement input = SelectionConverter.getInput(this.fEditor);
        if (!ActionUtil.isProcessable(this.getShell(), input)) {
            return;
        }
        IJavaElement[] elements = SelectionConverter.codeResolveOrInputHandled(this.fEditor, this.getShell(), OpenTypeHierarchyAction.getDialogTitle());
        if (elements == null) {
            return;
        }
        ArrayList<IJavaElement> candidates = new ArrayList<IJavaElement>(elements.length);
        for (int i = 0; i < elements.length; ++i) {
            IJavaElement[] resolvedElements = OpenTypeHierarchyUtil.getCandidates(elements[i]);
            if (resolvedElements == null) continue;
            candidates.addAll(Arrays.asList(resolvedElements));
        }
        this.run(candidates.toArray(new IJavaElement[candidates.size()]));
    }

    public void run(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return;
        }
        Object input = selection.getFirstElement();
        if (!(input instanceof IJavaElement)) {
            IStatus status = OpenTypeHierarchyAction.createStatus(ActionMessages.getString("OpenTypeHierarchyAction.messages.no_java_element"));
            ErrorDialog.openError((Shell)this.getShell(), (String)OpenTypeHierarchyAction.getDialogTitle(), (String)ActionMessages.getString("OpenTypeHierarchyAction.messages.title"), (IStatus)status);
            return;
        }
        IJavaElement element = (IJavaElement)input;
        if (!ActionUtil.isProcessable(this.getShell(), element)) {
            return;
        }
        ArrayList result = new ArrayList(1);
        IStatus status = OpenTypeHierarchyAction.compileCandidates(result, element);
        if (status.isOK()) {
            this.run(result.toArray(new IJavaElement[result.size()]));
        } else {
            ErrorDialog.openError((Shell)this.getShell(), (String)OpenTypeHierarchyAction.getDialogTitle(), (String)ActionMessages.getString("OpenTypeHierarchyAction.messages.title"), (IStatus)status);
        }
    }

    public void run(IJavaElement[] elements) {
        if (elements.length == 0) {
            this.getShell().getDisplay().beep();
            return;
        }
        OpenTypeHierarchyUtil.open(elements, this.getSite().getWorkbenchWindow());
    }

    private static String getDialogTitle() {
        return ActionMessages.getString("OpenTypeHierarchyAction.dialog.title");
    }

    private static IStatus compileCandidates(List result, IJavaElement elem) {
        Status ok = new Status(0, JavaPlugin.getPluginId(), 0, "", null);
        try {
            switch (elem.getElementType()) {
                case 2: 
                case 3: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    result.add(elem);
                    return ok;
                }
                case 4: {
                    if (((IPackageFragment)elem).containsJavaResources()) {
                        result.add(elem);
                        return ok;
                    }
                    return OpenTypeHierarchyAction.createStatus(ActionMessages.getString("OpenTypeHierarchyAction.messages.no_java_resources"));
                }
                case 11: {
                    result.add(elem.getAncestor(4));
                    return ok;
                }
                case 13: {
                    IImportDeclaration decl = (IImportDeclaration)elem;
                    elem = decl.isOnDemand() ? JavaModelUtil.findTypeContainer(elem.getJavaProject(), Signature.getQualifier((String)elem.getElementName())) : elem.getJavaProject().findType(elem.getElementName());
                    if (elem != null) {
                        result.add(elem);
                        return ok;
                    }
                    elem = elem.getAncestor(5);
                }
                case 6: {
                    result.add(((IClassFile)elem).getType());
                    return ok;
                }
                case 5: {
                    ICompilationUnit cu = (ICompilationUnit)elem;
                    IType[] types = cu.getTypes();
                    if (types.length > 0) {
                        result.addAll(Arrays.asList(types));
                        return ok;
                    }
                    return OpenTypeHierarchyAction.createStatus(ActionMessages.getString("OpenTypeHierarchyAction.messages.no_types"));
                }
            }
        }
        catch (JavaModelException e) {
            return e.getStatus();
        }
        return OpenTypeHierarchyAction.createStatus(ActionMessages.getString("OpenTypeHierarchyAction.messages.no_valid_java_element"));
    }

    private static IStatus createStatus(String message) {
        return new Status(1, JavaPlugin.getPluginId(), 10001, message, null);
    }
}

