/*
 * glob - expand file name function
 */

#ifndef GLOB_H
#define GLOB_H


/*
 * Prototype definitions for Standard and Non-standard compilers
 */

#define _NEAR
#define _CDECL
#define _FAR_
#define _LOADDS_

#ifdef MSDOS

#  if defined(_DLL) && !defined(_MT)
#    error Cannot define _DLL without _MT
#  endif

#  ifdef _DLL
#    undef _LOADDS_
#    define _LOADDS_	_loadds
#  endif

#  ifdef _MT
#    undef _FAR_
#    define _FAR_	_far
#  endif

#  ifndef __STDC__
#    define __STDC__	1
#  endif

#  undef _CDECL
#  define _CDECL	cdecl

#  undef _NEAR
#  define _NEAR		near
#endif

#ifdef __STDC__
#  define _PROTO(p)	p
#else
#  define _PROTO(p)	()
#  undef  const
#  undef  volatile
#endif


typedef struct glob_t {
    int		gl_flags;		/* Saved flag value		*/
    int		gl_offs;		/* Offset into paths to start	*/
    int		gl_pathc;		/* Number of entries		*/
					/* Function			*/
    int		(_CDECL *gl_ef) _PROTO ((char *, int));
    char	**gl_pathv;		/* Pointers to path		*/
} glob_t;

#define	GLOB_ERR	0x0001		/* Stop on error		*/
#define GLOB_MARK	0x0002		/* Mark directories		*/
#define	GLOB_NOSORT	0x0004		/* No sorting			*/
#define GLOB_NOCHECK	0x0008		/* No match returns pattern	*/
#define GLOB_DOOFFS	0x0010		/* Add null pointers		*/
#define GLOB_APPEND	0x0020		/* Append file names		*/

#define GLOB_ABEND	-1		/* Error			*/
#define GLOB_NOSPACE	-2		/* Out of space			*/

extern int _CDECL	glob	 _PROTO ((char *, int,
					  int (_CDECL *)(char *,
							 int), glob_t *));
extern void _CDECL	globfree _PROTO ((glob_t *));
#endif
