/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.projection;

import com.google.common.base.Optional;
import groovy.lang.Closure;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.internal.Cast;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.typeconversion.TypeConverter;
import org.gradle.model.internal.core.DefaultModelViewState;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.TypeCompatibilityModelProjectionSupport;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.manage.binding.StructBindings;
import org.gradle.model.internal.manage.instance.ManagedInstance;
import org.gradle.model.internal.manage.instance.ManagedProxyFactory;
import org.gradle.model.internal.manage.instance.ModelElementState;
import org.gradle.model.internal.manage.schema.ManagedImplSchema;
import org.gradle.model.internal.manage.schema.ModelProperty;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ScalarCollectionSchema;
import org.gradle.model.internal.manage.schema.StructSchema;
import org.gradle.model.internal.manage.schema.extract.ScalarCollectionModelView;
import org.gradle.model.internal.type.ModelType;

public class ManagedModelProjection<M>
extends TypeCompatibilityModelProjectionSupport<M> {
    private static final ModelType<? extends Collection<?>> COLLECTION_MODEL_TYPE = new ModelType<Collection<?>>(){};
    private final StructSchema<M> schema;
    private final StructBindings<?> bindings;
    private final ManagedProxyFactory proxyFactory;
    private final TypeConverter typeConverter;

    public ManagedModelProjection(StructSchema<M> schema, StructBindings<?> bindings, ManagedProxyFactory proxyFactory, TypeConverter typeConverter) {
        super(schema.getType());
        this.schema = schema;
        this.bindings = bindings;
        this.proxyFactory = proxyFactory;
        this.typeConverter = typeConverter;
    }

    @Override
    protected ModelView<M> toView(final MutableModelNode modelNode, final ModelRuleDescriptor ruleDescriptor, final boolean writable) {
        final DefaultModelViewState state = new DefaultModelViewState(modelNode.getPath(), this.getType(), ruleDescriptor, writable, true);
        return new ModelView<M>(){
            private final Map<String, Object> propertyViews = new HashMap<String, Object>();

            @Override
            public ModelPath getPath() {
                return modelNode.getPath();
            }

            @Override
            public ModelType<M> getType() {
                return ManagedModelProjection.this.getType();
            }

            @Override
            public M getInstance() {
                return ManagedModelProjection.this.proxyFactory.createProxy(new State(), ManagedModelProjection.this.schema, ManagedModelProjection.this.bindings, ManagedModelProjection.this.typeConverter);
            }

            @Override
            public void close() {
                state.close();
            }

            class State
            implements ModelElementState {
                State() {
                }

                @Override
                public MutableModelNode getBackingNode() {
                    return modelNode;
                }

                @Override
                public String getDisplayName() {
                    return this.getType().getDisplayName() + " '" + modelNode.getPath() + "'";
                }

                public boolean equals(Object obj) {
                    if (obj == this) {
                        return true;
                    }
                    if (obj == null || obj.getClass() != this.getClass()) {
                        return false;
                    }
                    State other = (State)Cast.uncheckedCast((Object)obj);
                    return modelNode == other.getBackingNode();
                }

                public int hashCode() {
                    return modelNode.hashCode();
                }

                @Override
                public Object get(String name) {
                    state.assertCanReadChildren();
                    if (propertyViews.containsKey(name)) {
                        return propertyViews.get(name);
                    }
                    ModelProperty<?> property = ManagedModelProjection.this.schema.getProperty(name);
                    Object value = this.doGet(property, name);
                    propertyViews.put(name, value);
                    return value;
                }

                private <T> T doGet(ModelProperty<T> property, String propertyName) {
                    ModelView<T> modelView;
                    ModelType<T> propertyType = property.getType();
                    MutableModelNode propertyNode = modelNode.getLink(propertyName);
                    propertyNode.ensureUsable();
                    if (writable) {
                        modelView = propertyNode.asMutable(propertyType, ruleDescriptor);
                        if (state.isClosed()) {
                            modelView.close();
                        }
                    } else {
                        modelView = propertyNode.asImmutable(propertyType, ruleDescriptor);
                    }
                    return modelView.getInstance();
                }

                @Override
                public void apply(String name, Closure<?> action) {
                    state.assertCanMutate();
                    ClosureBackedAction.execute((Object)this.get(name), action);
                }

                @Override
                public void set(String name, Object value) {
                    state.assertCanMutate();
                    ModelProperty<?> property = ManagedModelProjection.this.schema.getProperty(name);
                    value = this.doSet(name, value, property);
                    propertyViews.put(name, value);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                private <T> Object doSet(String name, Object value, ModelProperty<T> property) {
                    ModelSchema<T> propertySchema = property.getSchema();
                    MutableModelNode propertyNode = modelNode.getLink(name);
                    propertyNode.ensureUsable();
                    if (propertySchema instanceof ManagedImplSchema) {
                        if (propertySchema instanceof ScalarCollectionSchema) {
                            ModelView modelView = propertyNode.asMutable(COLLECTION_MODEL_TYPE, ruleDescriptor);
                            return ((ScalarCollectionModelView)modelView).setValue(value);
                        }
                        if (value == null) {
                            propertyNode.setTarget(null);
                            return value;
                        } else {
                            if (!(value instanceof ManagedInstance)) throw new IllegalArgumentException(String.format("Only managed model instances can be set as property '%s' of class '%s'", name, this.getType()));
                            ManagedInstance managedInstance = (ManagedInstance)value;
                            MutableModelNode targetNode = managedInstance.getBackingNode();
                            propertyNode.setTarget(targetNode);
                        }
                        return value;
                    } else {
                        Object castValue = Cast.uncheckedCast((Object)value);
                        propertyNode.setPrivateData(property.getType(), castValue);
                    }
                    return value;
                }
            }
        };
    }

    @Override
    public Optional<String> getValueDescription(MutableModelNode modelNode) {
        Object instance = modelNode.asImmutable(ModelType.untyped(), null).getInstance();
        if (instance == null || JavaReflectionUtil.hasDefaultToString((Object)instance)) {
            return Optional.absent();
        }
        return Optional.of((Object)this.toStringValueDescription(instance));
    }
}

