/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.infos;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.projectRoots.JavaSdkVersion;
import org.jetbrains.kotlin.com.intellij.openapi.projectRoots.JavaVersionService;
import org.jetbrains.kotlin.com.intellij.openapi.util.Computable;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.GenericsUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiConditionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiDiamondType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiEllipsisType;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiFunctionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParenthesizedExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiResolveHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import org.jetbrains.kotlin.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.ThreeState;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class MethodCandidateInfo
extends CandidateInfo {
    public static final RecursionGuard ourOverloadGuard = RecursionManager.createGuard("overload.guard");
    public static final ThreadLocal<Map<PsiElement, CurrentCandidateProperties>> CURRENT_CANDIDATE = new ThreadLocal();
    @ApplicabilityLevelConstant
    private volatile int myApplicabilityLevel;
    @ApplicabilityLevelConstant
    private volatile int myPertinentApplicabilityLevel;
    private final PsiElement myArgumentList;
    private final PsiType[] myArgumentTypes;
    private final PsiType[] myTypeArguments;
    private PsiSubstitutor myCalcedSubstitutor;
    private volatile String myInferenceError;
    private final ThreadLocal<String> myApplicabilityError;
    private final LanguageLevel myLanguageLevel;

    public MethodCandidateInfo(@NotNull PsiElement candidate2, PsiSubstitutor substitutor2, boolean accessProblem, boolean staticsProblem, PsiElement argumentList2, PsiElement currFileContext, @Nullable PsiType[] argumentTypes2, PsiType[] typeArguments2) {
        if (candidate2 == null) {
            MethodCandidateInfo.$$$reportNull$$$0(0);
        }
        this(candidate2, substitutor2, accessProblem, staticsProblem, argumentList2, currFileContext, argumentTypes2, typeArguments2, PsiUtil.getLanguageLevel(argumentList2));
    }

    public MethodCandidateInfo(@NotNull PsiElement candidate2, @NotNull PsiSubstitutor substitutor2, boolean accessProblem, boolean staticsProblem, PsiElement argumentList2, PsiElement currFileContext, @Nullable PsiType[] argumentTypes2, PsiType[] typeArguments2, @NotNull LanguageLevel languageLevel) {
        if (candidate2 == null) {
            MethodCandidateInfo.$$$reportNull$$$0(1);
        }
        if (substitutor2 == null) {
            MethodCandidateInfo.$$$reportNull$$$0(2);
        }
        if (languageLevel == null) {
            MethodCandidateInfo.$$$reportNull$$$0(3);
        }
        super(candidate2, substitutor2, accessProblem, staticsProblem, currFileContext);
        this.myApplicabilityError = new ThreadLocal();
        this.myArgumentList = argumentList2;
        this.myArgumentTypes = argumentTypes2;
        this.myTypeArguments = typeArguments2;
        this.myLanguageLevel = languageLevel;
    }

    public boolean isVarargs() {
        return false;
    }

    public boolean isApplicable() {
        return this.getPertinentApplicabilityLevel() != 1;
    }

    @ApplicabilityLevelConstant
    private int getApplicabilityLevelInner() {
        PsiType[] argumentTypes2 = this.getArgumentTypes();
        if (argumentTypes2 == null) {
            return 1;
        }
        int level = PsiUtil.getApplicabilityLevel(this.getElement(), this.getSubstitutor(), argumentTypes2, this.myLanguageLevel);
        if (level > 1 && !this.isTypeArgumentsApplicable()) {
            level = 1;
        }
        return level;
    }

    @ApplicabilityLevelConstant
    public int getApplicabilityLevel() {
        int result2 = this.myApplicabilityLevel;
        if (result2 == 0) {
            this.myApplicabilityLevel = result2 = this.getApplicabilityLevelInner();
        }
        return result2;
    }

    @ApplicabilityLevelConstant
    public int getPertinentApplicabilityLevel() {
        int result2 = this.myPertinentApplicabilityLevel;
        if (result2 == 0) {
            this.myPertinentApplicabilityLevel = result2 = this.getPertinentApplicabilityLevelInner();
        }
        return result2;
    }

    @ApplicabilityLevelConstant
    public int getPertinentApplicabilityLevelInner() {
        if (this.myArgumentList == null || !this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
            return this.getApplicabilityLevel();
        }
        PsiMethod method = this.getElement();
        if (this.isToInferApplicability()) {
            if (!MethodCandidateInfo.isOverloadCheck()) {
                this.getSubstitutor(false);
            }
            if (this.myApplicabilityError.get() != null || this.isPotentiallyCompatible() != ThreeState.YES) {
                return 1;
            }
            return this.isVarargs() ? 2 : 3;
        }
        PsiSubstitutor substitutor2 = this.getSubstitutor(false);
        int level = this.computeForOverloadedCandidate(() -> {
            PsiType[] argumentTypes2 = this.getArgumentTypes();
            if (argumentTypes2 == null) {
                return 1;
            }
            int level1 = PsiUtil.getApplicabilityLevel(method, substitutor2, argumentTypes2, this.myLanguageLevel);
            if (!this.isVarargs() && level1 < 3) {
                return 1;
            }
            return level1;
        }, substitutor2, this.isVarargs(), true);
        if (level > 1 && !this.isTypeArgumentsApplicable(() -> substitutor2)) {
            level = 1;
        }
        return level;
    }

    public boolean isToInferApplicability() {
        return this.myTypeArguments == null && this.getElement().hasTypeParameters() && !this.isRawSubstitution();
    }

    public ThreeState isPotentiallyCompatible() {
        if (this.myArgumentList instanceof PsiExpressionList) {
            PsiMethod method = this.getElement();
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            PsiExpression[] expressions = ((PsiExpressionList)this.myArgumentList).getExpressions();
            if (!this.isVarargs() && this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                if (expressions.length != parameters2.length) {
                    return ThreeState.NO;
                }
            } else {
                if (expressions.length < parameters2.length - 1) {
                    return ThreeState.NO;
                }
                if (parameters2.length == 0 && expressions.length != parameters2.length) {
                    return ThreeState.NO;
                }
            }
            boolean unsure = false;
            for (int i = 0; i < expressions.length; ++i) {
                ThreeState compatible;
                PsiType formalParameterType;
                PsiExpression expression2 = expressions[i];
                PsiType psiType = formalParameterType = i < parameters2.length ? parameters2[i].getType() : parameters2[parameters2.length - 1].getType();
                if (formalParameterType instanceof PsiEllipsisType && this.isVarargs()) {
                    formalParameterType = ((PsiEllipsisType)formalParameterType).getComponentType();
                }
                if ((compatible = MethodCandidateInfo.isPotentialCompatible(expression2, this.getSiteSubstitutor().substitute(formalParameterType), method)) == ThreeState.NO) {
                    return ThreeState.NO;
                }
                if (compatible != ThreeState.UNSURE) continue;
                unsure = true;
            }
            if (unsure) {
                return ThreeState.UNSURE;
            }
            if (method.hasTypeParameters() && this.myTypeArguments != null) {
                return ThreeState.fromBoolean(method.getTypeParameters().length == this.myTypeArguments.length);
            }
        }
        return ThreeState.YES;
    }

    private static ThreeState isPotentialCompatible(PsiExpression expression2, PsiType formalType, PsiMethod method) {
        if (expression2 instanceof PsiFunctionalExpression) {
            PsiClass targetTypeParameter = PsiUtil.resolveClassInClassTypeOnly(formalType);
            if (targetTypeParameter instanceof PsiTypeParameter && method.equals(((PsiTypeParameter)targetTypeParameter).getOwner())) {
                return ThreeState.YES;
            }
            if (!LambdaUtil.isFunctionalType(formalType)) {
                return ThreeState.NO;
            }
            if (!((PsiFunctionalExpression)expression2).isPotentiallyCompatible(formalType)) {
                return ThreeState.UNSURE;
            }
        } else {
            if (expression2 instanceof PsiParenthesizedExpression) {
                return MethodCandidateInfo.isPotentialCompatible(((PsiParenthesizedExpression)expression2).getExpression(), formalType, method);
            }
            if (expression2 instanceof PsiConditionalExpression) {
                ThreeState thenCompatible = MethodCandidateInfo.isPotentialCompatible(((PsiConditionalExpression)expression2).getThenExpression(), formalType, method);
                ThreeState elseCompatible = MethodCandidateInfo.isPotentialCompatible(((PsiConditionalExpression)expression2).getElseExpression(), formalType, method);
                if (thenCompatible == ThreeState.NO || elseCompatible == ThreeState.NO) {
                    return ThreeState.NO;
                }
                if (thenCompatible == ThreeState.UNSURE || elseCompatible == ThreeState.UNSURE) {
                    return ThreeState.UNSURE;
                }
            }
        }
        return ThreeState.YES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T computeForOverloadedCandidate(Computable<T> computable, PsiSubstitutor substitutor2, boolean varargs, boolean applicabilityCheck) {
        Map<PsiElement, CurrentCandidateProperties> map2 = CURRENT_CANDIDATE.get();
        if (map2 == null) {
            map2 = ContainerUtil.createConcurrentWeakMap();
            CURRENT_CANDIDATE.set(map2);
        }
        PsiElement argumentList2 = this.getMarkerList();
        CurrentCandidateProperties alreadyThere = map2.put(argumentList2, new CurrentCandidateProperties(this, substitutor2, varargs, applicabilityCheck));
        try {
            T t = computable.compute();
            return t;
        }
        finally {
            if (alreadyThere == null) {
                map2.remove(argumentList2);
            } else {
                map2.put(argumentList2, alreadyThere);
            }
        }
    }

    @NotNull
    public PsiSubstitutor getSiteSubstitutor() {
        PsiSubstitutor incompleteSubstitutor = super.getSubstitutor();
        if (this.myTypeArguments != null) {
            PsiMethod method = this.getElement();
            PsiTypeParameter[] typeParams = method.getTypeParameters();
            for (int i = 0; i < this.myTypeArguments.length && i < typeParams.length; ++i) {
                incompleteSubstitutor = incompleteSubstitutor.put(typeParams[i], this.myTypeArguments[i]);
            }
        }
        PsiSubstitutor psiSubstitutor = incompleteSubstitutor;
        if (psiSubstitutor == null) {
            MethodCandidateInfo.$$$reportNull$$$0(4);
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiSubstitutor getSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.getSubstitutor(true);
        if (psiSubstitutor == null) {
            MethodCandidateInfo.$$$reportNull$$$0(5);
        }
        return psiSubstitutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public PsiSubstitutor getSubstitutor(boolean includeReturnConstraint) {
        PsiSubstitutor substitutor2 = this.myCalcedSubstitutor;
        if (substitutor2 == null || !includeReturnConstraint && this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8) || MethodCandidateInfo.isOverloadCheck()) {
            PsiSubstitutor incompleteSubstitutor = super.getSubstitutor();
            PsiMethod method = this.getElement();
            if (this.myTypeArguments == null) {
                RecursionGuard.StackStamp stackStamp = PsiDiamondType.ourDiamondGuard.markStack();
                this.myApplicabilityError.remove();
                try {
                    PsiSubstitutor inferredSubstitutor = this.inferTypeArguments(DefaultParameterTypeInferencePolicy.INSTANCE, includeReturnConstraint);
                    if (!stackStamp.mayCacheNow() || MethodCandidateInfo.isOverloadCheck() || !includeReturnConstraint && this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8) || this.getMarkerList() != null && PsiResolveHelper.ourGraphGuard.currentStack().contains(this.getMarkerList().getParent()) || LambdaUtil.isLambdaParameterCheck()) {
                        PsiSubstitutor psiSubstitutor = inferredSubstitutor;
                        PsiSubstitutor psiSubstitutor2 = psiSubstitutor;
                        if (psiSubstitutor2 == null) {
                            MethodCandidateInfo.$$$reportNull$$$0(6);
                        }
                        return psiSubstitutor2;
                    }
                    this.myInferenceError = this.myApplicabilityError.get();
                    this.myCalcedSubstitutor = substitutor2 = inferredSubstitutor;
                }
                finally {
                    if (includeReturnConstraint) {
                        this.myApplicabilityError.remove();
                    }
                }
            } else {
                PsiTypeParameter[] typeParams = method.getTypeParameters();
                for (int i = 0; i < this.myTypeArguments.length && i < typeParams.length; incompleteSubstitutor = incompleteSubstitutor.put(typeParams[i], this.myTypeArguments[i]), ++i) {
                }
                this.myCalcedSubstitutor = substitutor2 = incompleteSubstitutor;
            }
        }
        PsiSubstitutor psiSubstitutor = substitutor2;
        if (psiSubstitutor == null) {
            MethodCandidateInfo.$$$reportNull$$$0(7);
        }
        return psiSubstitutor;
    }

    public static boolean isOverloadCheck() {
        return !ourOverloadGuard.currentStack().isEmpty();
    }

    public boolean isTypeArgumentsApplicable() {
        return this.isTypeArgumentsApplicable(() -> this.getSubstitutor(false));
    }

    private boolean isTypeArgumentsApplicable(Computable<PsiSubstitutor> computable) {
        PsiMethod psiMethod = this.getElement();
        PsiTypeParameter[] typeParams = psiMethod.getTypeParameters();
        if (this.myTypeArguments != null && typeParams.length != this.myTypeArguments.length && !PsiUtil.isLanguageLevel7OrHigher(psiMethod)) {
            return typeParams.length == 0 && JavaVersionService.getInstance().isAtLeast(psiMethod, JavaSdkVersion.JDK_1_7);
        }
        return GenericsUtil.isTypeArgumentsApplicable(typeParams, computable.compute(), this.getParent());
    }

    protected PsiElement getParent() {
        return this.myArgumentList != null ? this.myArgumentList.getParent() : null;
    }

    @Override
    public boolean isValidResult() {
        return super.isValidResult() && this.isApplicable();
    }

    @Override
    @NotNull
    public PsiMethod getElement() {
        PsiMethod psiMethod = (PsiMethod)super.getElement();
        if (psiMethod == null) {
            MethodCandidateInfo.$$$reportNull$$$0(8);
        }
        return psiMethod;
    }

    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull ParameterTypeInferencePolicy policy, boolean includeReturnConstraint) {
        if (policy == null) {
            MethodCandidateInfo.$$$reportNull$$$0(9);
        }
        PsiSubstitutor psiSubstitutor = this.inferTypeArguments(policy, this.myArgumentList instanceof PsiExpressionList ? ((PsiExpressionList)this.myArgumentList).getExpressions() : PsiExpression.EMPTY_ARRAY, includeReturnConstraint);
        if (psiSubstitutor == null) {
            MethodCandidateInfo.$$$reportNull$$$0(10);
        }
        return psiSubstitutor;
    }

    public PsiSubstitutor inferSubstitutorFromArgs(@NotNull ParameterTypeInferencePolicy policy, PsiExpression[] arguments2) {
        if (policy == null) {
            MethodCandidateInfo.$$$reportNull$$$0(11);
        }
        if (this.myTypeArguments == null) {
            return this.inferTypeArguments(policy, arguments2, true);
        }
        return this.getSiteSubstitutor();
    }

    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull ParameterTypeInferencePolicy policy, @NotNull PsiExpression[] arguments2, boolean includeReturnConstraint) {
        if (policy == null) {
            MethodCandidateInfo.$$$reportNull$$$0(12);
        }
        if (arguments2 == null) {
            MethodCandidateInfo.$$$reportNull$$$0(13);
        }
        PsiSubstitutor psiSubstitutor = this.computeForOverloadedCandidate(() -> {
            if (arguments2 == null) {
                MethodCandidateInfo.$$$reportNull$$$0(15);
            }
            if (policy == null) {
                MethodCandidateInfo.$$$reportNull$$$0(16);
            }
            PsiMethod method = this.getElement();
            PsiTypeParameter[] typeParameters2 = method.getTypeParameters();
            if (this.isRawSubstitution()) {
                return JavaPsiFacade.getInstance(method.getProject()).getElementFactory().createRawSubstitutor(this.mySubstitutor, typeParameters2);
            }
            PsiElement parent2 = this.getParent();
            if (parent2 == null) {
                return PsiSubstitutor.EMPTY;
            }
            Project project = method.getProject();
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance(project);
            return javaPsiFacade.getResolveHelper().inferTypeArguments(typeParameters2, method.getParameterList().getParameters(), arguments2, this.mySubstitutor, parent2, policy, this.myLanguageLevel);
        }, super.getSubstitutor(), policy.isVarargsIgnored() || this.isVarargs(), !includeReturnConstraint);
        if (psiSubstitutor == null) {
            MethodCandidateInfo.$$$reportNull$$$0(14);
        }
        return psiSubstitutor;
    }

    public boolean isRawSubstitution() {
        PsiClass containingClass;
        PsiMethod method = this.getElement();
        return !method.hasModifierProperty("static") && (containingClass = method.getContainingClass()) != null && PsiUtil.isRawSubstitutor(containingClass, this.mySubstitutor);
    }

    protected PsiElement getMarkerList() {
        return this.myArgumentList;
    }

    public boolean isInferencePossible() {
        return this.myArgumentList != null && this.myArgumentList.isValid();
    }

    public static CurrentCandidateProperties getCurrentMethod(PsiElement context) {
        Map<PsiElement, CurrentCandidateProperties> currentMethodCandidates = CURRENT_CANDIDATE.get();
        return currentMethodCandidates != null ? currentMethodCandidates.get(context) : null;
    }

    public static void updateSubstitutor(PsiElement context, PsiSubstitutor newSubstitutor) {
        CurrentCandidateProperties candidateProperties = MethodCandidateInfo.getCurrentMethod(context);
        if (candidateProperties != null) {
            candidateProperties.setSubstitutor(newSubstitutor);
        }
    }

    @Nullable
    public PsiType[] getArgumentTypes() {
        return this.myArgumentTypes;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.isVarargs() == ((MethodCandidateInfo)o).isVarargs();
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + (this.isVarargs() ? 1 : 0);
    }

    public void setApplicabilityError(String applicabilityError) {
        this.myApplicabilityError.set(applicabilityError);
    }

    public String getInferenceErrorMessage() {
        this.getSubstitutor();
        return this.myInferenceError;
    }

    public String getInferenceErrorMessageAssumeAlreadyComputed() {
        return this.myInferenceError;
    }

    public CurrentCandidateProperties createProperties() {
        return new CurrentCandidateProperties(this, this.getSiteSubstitutor(), this.isVarargs(), false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/infos/MethodCandidateInfo";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/infos/MethodCandidateInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSiteSubstitutor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 10: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "inferTypeArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: {
                break;
            }
            case 9: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeArguments";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "inferSubstitutorFromArgs";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$inferTypeArguments$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static @interface ApplicabilityLevelConstant {
    }

    public static class ApplicabilityLevel {
        public static final int NOT_APPLICABLE = 1;
        public static final int VARARGS = 2;
        public static final int FIXED_ARITY = 3;
    }

    public static class CurrentCandidateProperties {
        private final MethodCandidateInfo myMethod;
        private PsiSubstitutor mySubstitutor;
        private boolean myVarargs;
        private boolean myApplicabilityCheck;

        private CurrentCandidateProperties(MethodCandidateInfo info, PsiSubstitutor substitutor2, boolean varargs, boolean applicabilityCheck) {
            this.myMethod = info;
            this.mySubstitutor = substitutor2;
            this.myVarargs = varargs;
            this.myApplicabilityCheck = applicabilityCheck;
        }

        public PsiMethod getMethod() {
            return this.myMethod.getElement();
        }

        public MethodCandidateInfo getInfo() {
            return this.myMethod;
        }

        public PsiSubstitutor getSubstitutor() {
            return this.mySubstitutor;
        }

        public void setSubstitutor(PsiSubstitutor substitutor2) {
            this.mySubstitutor = substitutor2;
        }

        public boolean isVarargs() {
            return this.myVarargs;
        }

        public void setVarargs(boolean varargs) {
            this.myVarargs = varargs;
        }

        public boolean isApplicabilityCheck() {
            return this.myApplicabilityCheck;
        }

        public void setApplicabilityCheck(boolean applicabilityCheck) {
            this.myApplicabilityCheck = applicabilityCheck;
        }
    }
}

