/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.util.ArrayDeque;
import java.util.Deque;
import org.dita.dost.util.Constants;
import org.dita.dost.writer.TopicCleanFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MapCleanFilter
extends TopicCleanFilter {
    private final Deque<Keep> stack = new ArrayDeque<Keep>();

    @Override
    public void startDocument() throws SAXException {
        this.stack.clear();
        this.getContentHandler().startDocument();
        this.calculatePathToProjectDirs();
    }

    @Override
    public void endDocument() throws SAXException {
        assert (this.stack.isEmpty());
        this.getContentHandler().endDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String cls = atts.getValue("class");
        if (!this.stack.isEmpty() && this.stack.element() == Keep.DISCARD_BRANCH) {
            this.stack.addFirst(Keep.DISCARD_BRANCH);
        } else if (Constants.SUBMAP.matches(cls)) {
            this.stack.addFirst(Keep.DISCARD);
        } else if (Constants.DITA_OT_D_KEYDEF.matches(cls)) {
            this.stack.addFirst(Keep.DISCARD_BRANCH);
        } else {
            this.stack.addFirst(Keep.RETAIN);
        }
        if (this.stack.isEmpty() || this.stack.peekFirst() == Keep.RETAIN) {
            this.getContentHandler().startElement(uri, localName, qName, atts);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.stack.removeFirst() == Keep.RETAIN) {
            this.getContentHandler().endElement(uri, localName, qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.stack.peekFirst() != Keep.DISCARD_BRANCH) {
            this.getContentHandler().characters(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.stack.peekFirst() != Keep.DISCARD_BRANCH) {
            this.getContentHandler().ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        String res = this.getProcessingInstruction(target, data);
        if (this.stack.isEmpty() || this.stack.peekFirst() != Keep.DISCARD_BRANCH) {
            this.getContentHandler().processingInstruction(target, res);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (this.stack.peekFirst() != Keep.DISCARD_BRANCH) {
            this.getContentHandler().skippedEntity(name);
        }
    }

    private static enum Keep {
        RETAIN,
        DISCARD,
        DISCARD_BRANCH;

    }
}

