#if !defined (DEBUG)
#define DEBUG 1
#endif

#include <AppKit.h>
#include <InterfaceKit.h>
#include <Debug.h>

#include <stdio.h>
#include <stdlib.h>
#include "gtk/gtk.h"
#include "libgimp/gimp.h"
#include "libgimp/gimpui.h"
#include "libgimp/gimpprotocol.h"

#include "IEWindow.h"
#include "GimpStub.h"
#include "FilterViews.h"

//-----------------------------------------------------------------------------------------------
//	To port a GIMP filter,
//
//		Update DoIt
//		
//-----------------------------------------------------------------------------------------------
typedef struct {
	int32	mode;
	int32	length;
	int32	angle;
} mblur_vals_t;

extern "C" mblur_vals_t		mbvals;

typedef struct ReturnValue {
	BMessage	*msg;
	bool		done;
};

class GIMPDlog : public IEWindow {
public:
	GIMPDlog (ReturnValue *ret, FILTER_NAME *filter, TFilterParams *parms);
	~GIMPDlog(void);

virtual	void		MessageReceived(BMessage *message);
virtual	bool		QuitRequested (void);
		void		DoPreview (void);
//public:
protected:
	FILTER_NAME			*fFilter;
	TFilterParams		*fParms;
	BSliderTextHelper	*fHelper;
	ReturnValue			*fReturn;
	int32				fMode, fLength, fAngle;
	bool				fPreview;
};

GIMPDlog::GIMPDlog (ReturnValue *ret, FILTER_NAME *filter, TFilterParams *parms) : IEWindow("mblur") {
	ASSERT (!ret->done); fReturn = ret; fReturn->msg = NULL;
	AddTemporaryBPath (NULL); fParms = parms; fFilter = filter;

	fMode = mbvals.mode; fLength = mbvals.length; fAngle = mbvals.angle;
	fPreview = true;
	Lock ();
	char	radioName[2] = { 48, 0 };
	*radioName = 48 + fMode;
	BControl	*ctl = (BControl *) FindView (radioName);
	ASSERT (ctl); if (ctl) ctl->SetValue (1);
	fHelper = new BSliderTextHelper ("Slider", "TE", this); fHelper->SetValue (fLength);
	new TAngleView (FindView ("Angle"), new BMessage ('Dir '));
	gProgressView = new TDlogProgressView (FindView ("Progress"));
	Unlock ();
	Show();
	DoPreview ();
}

GIMPDlog::~GIMPDlog(void) {
	if (!fReturn->msg) {
		fParms->fDst->Copy (*fParms->fSrc);
		FilterUpdate (fParms);
	} else  {
		if (!fPreview) {
			fPreview = true;
			DoPreview ();	//	We do the action if it was not previewed.
		}
		VERIFY (B_OK == fFilter->Archive (fReturn->msg, true));
	}
	delete fHelper;
	fReturn->done = true;
}

bool GIMPDlog::QuitRequested (void) {
	gProgressView = NULL;
	return true;
}

void GIMPDlog::DoPreview (void) {
	if (fPreview) {
		mblur_vals_t	values;
		values.mode = fMode; values.length = fLength; values.angle = fAngle;
		fFilter->SetValue (&values);
	}
}

// Handling of user interface and other events
void GIMPDlog::MessageReceived (BMessage *message) {
	int32			value;

	switch(message->what){
		case '_xPr':	//	DoMiniPreview (); break;
		case 'Sldr':	value = message->FindInt32 ("be:value"); if (value != fLength) { fLength = value; DoPreview (); } break;
		case 'View':	fPreview = !fPreview;
						if (fPreview) {
							DoPreview ();
						} else {
							//	Removes the preview by restoring the original image.
							fParms->fDst->Copy (*fParms->fSrc);
							FilterUpdate (fParms);
						}
						break;
		case 'Dir ':	value = message->FindInt32 ("be:value"); if (value != fAngle) { fAngle = value; DoPreview (); } break;
		case 1000:
		case 1001:
		case 1002:		if (int32(message->what - 1000) != fMode) { fMode = message->what - 1000; DoPreview (); } break;
		case 'Abut':	fFilter->DoAbout (); break;
		case 'OK  ':	fReturn->msg = new BMessage ('Parm'); mbvals.mode = fMode; mbvals.length = fLength; mbvals.angle = fAngle;
		case 'Esc ':	gProgressView = NULL; Quit (); break;
		default:		inherited::MessageReceived(message); break;
	}

}

void FILTER_NAME::DoIt (TFilterParams *parms, const void *values) {
	GParam	inputParms[6], *outputParms;
	gint	cntOutput;

	inputParms[0].type = PARAM_INT32; inputParms[0].data.d_int32 = RUN_NONINTERACTIVE;	//	TBD, determined by the message
	inputParms[2].type = PARAM_DRAWABLE; inputParms[2].data.d_drawable = gint32(parms);
	inputParms[3].type = PARAM_INT32; inputParms[3].data.d_int32 = ((const mblur_vals_t *)values)->mode;
	inputParms[4].type = PARAM_INT32; inputParms[4].data.d_int32 = ((const mblur_vals_t *)values)->length;
	inputParms[5].type = PARAM_INT32; inputParms[5].data.d_int32 = ((const mblur_vals_t *)values)->angle;
	(*PLUG_IN_INFO.run_proc) (fName, 6, inputParms, &cntOutput, &outputParms);
}

BMessage *FILTER_NAME::ApplyFilter (TFilterParams *parms) {
	BMessage	*result = NULL;

	if (fInited) {
		ASSERT (fLock == NULL);
		DoIt (parms, fData);
	} else {
		ReturnValue	returnVal;

		fLock = new Benaphore ("Synchro Dialog");
		returnVal.done = fChanged = false; fInited = true;
		AddTemporaryBPath (filterFile);
		new GIMPDlog (&returnVal, this, parms);
		do {
			if (fChanged) {
				fLock->Lock ();
				mblur_vals_t	tmpValues;
				memcpy (&tmpValues, fData, sizeof (mblur_vals_t));
				fChanged = false;
				fLock->Unlock ();
				DoIt (parms, &tmpValues);
				FilterUpdate (parms);
			} else {
				snooze (250000);
			}
		} while (!returnVal.done);
		result = returnVal.msg;
	}
	return result;
}

void FILTER_NAME::PrepareData (void) {
	fData = (void *) new char [sizeof(mblur_vals_t)]; fDataSize = sizeof (mblur_vals_t);
	ASSERT (fData);
}

void FILTER_NAME::DisposeData (void) {
	delete (mblur_vals_t *)fData;
}

void FILTER_NAME::SetValue (void *value) {
	ASSERT (fLock);
	fLock->Lock ();

	memcpy (fData, value, sizeof(mblur_vals_t));
	fChanged = true;
	fLock->Unlock ();
}

void gimp_get_data (gchar *id, gpointer data) {
	ASSERT (gCurFilter); gCurFilter->GetData (id, data);
}

void gimp_set_data (gchar *id, gpointer data, guint32 length) {
	ASSERT (gCurFilter); gCurFilter->SetData (id, data, length);
}

