/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.commonsio.input;

import coursierapi.shaded.commonsio.input.ProxyInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BoundedInputStream
extends ProxyInputStream {
    private long count;
    private long mark;
    private final long maxCount;
    private boolean propagateClose = true;

    @Deprecated
    public BoundedInputStream(InputStream inputStream, long maxCount) {
        this(inputStream, 0L, maxCount, true);
    }

    BoundedInputStream(InputStream inputStream, long count, long maxCount, boolean propagateClose) {
        super(inputStream);
        this.count = count;
        this.maxCount = maxCount;
        this.propagateClose = propagateClose;
    }

    @Override
    protected synchronized void afterRead(int n) throws IOException {
        if (n != -1) {
            this.count += (long)n;
        }
    }

    @Override
    public int available() throws IOException {
        if (this.isMaxCount()) {
            this.onMaxLength(this.maxCount, this.getCount());
            return 0;
        }
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        if (this.propagateClose) {
            this.in.close();
        }
    }

    public synchronized long getCount() {
        return this.count;
    }

    private boolean isMaxCount() {
        return this.maxCount >= 0L && this.getCount() >= this.maxCount;
    }

    @Override
    public synchronized void mark(int readLimit) {
        this.in.mark(readLimit);
        this.mark = this.count;
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    protected void onMaxLength(long maxLength, long count) throws IOException {
    }

    @Override
    public int read() throws IOException {
        if (this.isMaxCount()) {
            this.onMaxLength(this.maxCount, this.getCount());
            return -1;
        }
        return super.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.isMaxCount()) {
            this.onMaxLength(this.maxCount, this.getCount());
            return -1;
        }
        return super.read(b, off, (int)this.toReadLen(len));
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
        this.count = this.mark;
    }

    @Deprecated
    public void setPropagateClose(boolean propagateClose) {
        this.propagateClose = propagateClose;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        long skip = super.skip(this.toReadLen(n));
        this.count += skip;
        return skip;
    }

    private long toReadLen(long len) {
        return this.maxCount >= 0L ? Math.min(len, this.maxCount - this.getCount()) : len;
    }

    public String toString() {
        return this.in.toString();
    }
}

