/* vehicle.c */

/* window.c */


/* landscape.c */
void FindLandscapeHeight(TileInfo *ti, uint x, uint y);
void FindLandscapeHeightByTile(TileInfo *ti, uint tile);
uint GetTileSlope(uint tile, int *h);
int GetTileZ(uint tile);

void DoClearSquare(uint tile);
void CDECL ModifyTile(uint tile, uint flags, ...);
void SetMapExtraBits(uint tile, byte flags);
uint GetMapExtraBits(uint tile);
void RunTileLoop();

uint GetPartialZ(int x, int y, int corners);
uint16 GetSlopeZ(int x, int y);
uint32 GetTileTrackStatus(uint tile, int mode);
void GetAcceptedCargo(uint tile, AcceptedCargo *ac);
void ChangeTileOwner(uint tile, byte old_player, byte new_player);
void AnimateTile(uint tile);
void ClickTile(uint tile);
void GetTileDesc(uint tile, TileDesc *td);
void DrawTile(TileInfo *ti);

uint TileAddWrap(TileIndex tile, int add);
enum {
	TILE_WRAPPED = (uint)-1
};

bool IsValidTile(uint tile);

/* game.c */
byte *GetString(byte *buffr, uint16 string);
void InjectDparam(int amount);

int32 GetParamInt32();
int GetParamInt16();
int GetParamInt8();
int GetParamUint16();


/* sound.c */
void SndPlayTileFx(int sound, TileIndex tile);
void SndPlayVehicleFx(int sound, Vehicle *v);
void SndPlayFx(int sound);

/* clear_land.c */
void DrawHillyLandTile(TileInfo *ti);
void DrawClearLandTile(TileInfo *ti, byte set);
void DrawClearLandFence(TileInfo *ti, byte img);
void TileLoopClearHelper(uint tile);

/* station_land.c */
void StationPickerDrawSprite(int x, int y, int railtype, int image);

/* track_land.c */
void DrawTrainDepotSprite(int x, int y, int image, int railtype);

/* road_land.c */
void DrawRoadDepotSprite(int x, int y, int image);

/* water_land.c */
void DrawShipDepotSprite(int x, int y, int image);
void TileLoop_Water(uint tile);

/* players.c */
bool CheckPlayerHasMoney(int32 cost);
void SubtractMoneyFromPlayer(int32 cost);
void SubtractMoneyFromPlayerFract(byte player, int32 cost);
bool CheckOwnership(byte owner);

/* standard */
void NORETURN CDECL error(const char *str, ...);
void memswap(void *a, void *b, size_t size);

/* ttd.c */
uint32 Random();
uint RandomRange(uint max);

uint32 InteractiveRandom(); /* Used for random sequences that are not the same on the other end of the multiplayer link */

/* facedraw.c */
void DrawPlayerFace(uint32 face, int color, int x, int y);

/* texteff.c */
void MoveAllTextEffects();
void AddTextEffect(StringID msg, int x, int y, uint16 duration);
void InitTextEffects();
void DrawTextEffects(DrawPixelInfo *dpi);

bool AddAnimatedTile(uint tile);
void DeleteAnimatedTile(uint tile);
void AnimateAnimatedTiles();
void InitializeAnimatedTiles();

/* tunnel_cmd.c */
bool CheckTunnelInWay(uint tile, int z);

/* network.c */
void NetworkSend(int x, int y, uint32 p1, uint32 p2, uint flags, uint procc);
void NetworkConnect(const char *hostname, int port);
void NetworkPoll();
void NetworkListen(int port);
void NetworkInitialize();
bool RecorderStart(const char *file);
bool RecorderStop();
bool RecorderPlayback(const char *file);
void RecorderPoll();

/* misc_cmd.c */
void PlaceTreesRandomly();

uint GetTileDist(TileIndex xy1, TileIndex xy2);
uint GetTileDist1D(TileIndex xy1, TileIndex xy2);
uint GetTileDist1Db(TileIndex xy1, TileIndex xy2);
uint GetTileDistAdv(TileIndex xy1, TileIndex xy2);
bool CheckDistanceFromEdge(TileIndex tile, uint distance);

void InitializeLandscapeVariables(bool only_constants);

/* namegen.c */
byte MakeEnglishCityName(byte *buf, uint32 seed);
byte MakeFrenchCityName(byte *buf, uint32 seed);
byte MakeGermanCityName(byte *buf, uint32 seed);
byte MakeSpanishCityName(byte *buf, uint32 seed);
byte MakeAmericanCityName(byte *buf, uint32 seed);
byte MakeSillyCityName(byte *buf, uint32 seed);
byte MakeSwedishCityName(byte *buf, uint32 seed);
byte MakeDutchCityName(byte *buf, uint32 seed);

/* misc.c */
void DeleteName(StringID id);
byte *GetName(int id, byte *buff);
StringID AllocateName(const byte *name, byte skip);
void ConvertDayToYMD(YearMonthDay *ymd, uint16 date);

/* misc functions */
void MarkTileDirty(int x, int y);
void MarkTileDirtyByTile(TileIndex tile);
void InvalidateWindow(byte cls, uint16 number);
void InvalidateWindowWidget(byte cls, uint16 number, byte widget_index);
void InvalidateWindowClasses(byte cls);
void DeleteWindowById(WindowClass cls, WindowNumber number);

void SetObjectToPlaceWnd(uint32 icon, byte mode, Window *w);
void SetObjectToPlace(uint32 icon, byte mode, byte window_class, uint16 window_num);
enum {
	SOTP_ANIM_CURSOR = 0x10,
};

void ResetObjectToPlace();
bool ScrollMainWindowToTile(TileIndex tile);
bool ScrollMainWindowTo(int x, int y);
void DrawSprite(uint32 img, int x, int y);
bool EnsureNoVehicle(TileIndex tile);
void MarkAllViewportsDirty(int left, int top, int right, int bottom);
void ShowCostOrIncomeAnimation(int x, int y, int z, int32 cost);
void MarkWholeScreenDirty();

void DrawFoundation(TileInfo *ti, uint f);

bool CheckIfAuthorityRefuses(uint tile);
City *ClosestCityFromTile(uint tile, uint threshold);
void IncCityRating(City *city, int add, int max);

uint GetRoadBitsByTile(TileIndex tile);

int GetCityRadiusGroup(City *c, uint tile);

int32 GetTransportedGoodsIncome(uint num_pieces, uint dist, byte transit_days, byte cargo_type);

void ShowRenameSignWindow(SignStruct *ss);
int FindFirstBit(uint32 x);

void ShowHighscoreTable(int tbl);

TileIndex AdjustTileCoordRandomly(TileIndex a, byte rng);
bool SaveOrLoad(const char *filename, int mode);

void AfterLoadCity();

void AskExitGame();

void PauseGame();
void UnpauseGame();

void RedrawAutosave();

enum {
	SLD_LOAD_GAME = 0,
	SLD_LOAD_SCENARIO = 1,
	SLD_SAVE_GAME = 2,
	SLD_SAVE_SCENARIO = 3,
};
void ShowSaveLoadDialog(int mode);

void ttd_strlcpy(char *dst, const char *src, size_t len);

// callback from drivers that is called if the game size changes dynamically
void GameSizeChanged();
void ZoomInOrOutToCursor(bool in);
bool MakeScreenshot();
bool MakeWorldScreenshot(int left, int top, int width, int height, int zoom);
bool FileExists(const char *filename);
