/* $Id: industry_land.h 18409 2009-12-05 15:03:32Z frosch $ */

/*
 * This file is part of OpenTTD.
 * OpenTTD is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, version 2.
 * OpenTTD is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details. You should have received a copy of the GNU General Public License along with OpenTTD. If not, see <http://www.gnu.org/licenses/>.
 */

/** @file industry_land.h Information about the behaviour of the default industry tiles. */

/**
 * This is used to gather some data about animation
 * drawing in the industry code
 * Image_1-2-3 are in fact only offset in the sprites
 * used by the industry.
 * To specify an invalid one, either 255 or 0 is used,
 * depending of the industry.
 */
struct DrawIndustryAnimationStruct {
	int x;        ///< coordinate x of the first image offset
	byte image_1; ///< image offset 1
	byte image_2; ///< image offset 2
	byte image_3; ///< image offset 3
};

/**
 * Simple structure gathering x,y coordinates for
 * industries animations
 */
struct DrawIndustryCoordinates {
	byte x;  ///< coordinate x of the pair
	byte y;  ///< coordinate y of the pair
};

/**
 * Macro to ease the declaration of the array
 * @param s1 sprite ID of ground sprite
 * @param p1 palette ID of ground sprite
 * @param s2 sprite ID of building sprite
 * @param p2 palette ID of building sprite
 * @param sx coordinate x of the sprite
 * @param sy coordinate y of the sprite
 * @param w width of the sprite
 * @param h height of the sprite
 * @param dz virtual height of the sprite
 * @param p this allows to specify a special drawing procedure.
 * @see DrawBuildingsTileStruct */
#define M(s1, p1, s2, p2, sx, sy, w, h, dz, p) { { s1, p1 }, { s2, p2 }, sx, sy, w, h, dz, p }

/** Structure for industry tiles drawing */
static const DrawBuildingsTileStruct _industry_draw_tile_data[NEW_INDUSTRYTILEOFFSET * 4] = {
	M(     0xf54, PAL_NONE,      0x7db, PAL_NONE,  7,  0,  9,  9,  10, 0),
	M(     0xf54, PAL_NONE,      0x7dc, PAL_NONE,  7,  0,  9,  9,  30, 0),
	M(     0xf54, PAL_NONE,      0x7dd, PAL_NONE,  7,  0,  9,  9,  30, 0),
	M(     0x7e6, PAL_NONE,      0x7dd, PAL_NONE,  7,  0,  9,  9,  30, 0),
	M(     0x7e6, PAL_NONE,      0x7dd, PAL_NONE,  7,  0,  9,  9,  30, 0),
	M(     0x7e6, PAL_NONE,      0x7de, PAL_NONE,  7,  0,  9,  9,  30, 0),
	M(     0x7e6, PAL_NONE,      0x7df, PAL_NONE,  7,  0,  9,  9,  30, 0),
	M(     0x7e6, PAL_NONE,      0x7df, PAL_NONE,  7,  0,  9,  9,  30, 0),
	M(     0xf54, PAL_NONE,      0x7e0, PAL_NONE,  1,  2, 15,  9,  30, 0),
	M(     0xf54, PAL_NONE,      0x7e1, PAL_NONE,  1,  2, 15,  9,  30, 0),
	M(     0xf54, PAL_NONE,      0x7e2, PAL_NONE,  1,  2, 15,  9,  30, 0),
	M(     0x7e6, PAL_NONE,      0x7e2, PAL_NONE,  1,  2, 15,  9,  30, 0),
	M(     0xf54, PAL_NONE,      0x7e3, PAL_NONE,  4,  4,  9,  9,  30, 0),
	M(     0xf54, PAL_NONE,      0x7e4, PAL_NONE,  4,  4,  9,  9,  30, 0),
	M(     0xf54, PAL_NONE,      0x7e5, PAL_NONE,  4,  4,  9,  9,  30, 0),
	M(     0x7e6, PAL_NONE,      0x7e5, PAL_NONE,  4,  4,  9,  9,  30, 0),
	M(     0xf54, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0xf54, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0x7e6, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0x7e9, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0xf54, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0xf54, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0x7e6, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0x7e7, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0xf54, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0xf54, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0x7e6, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0x7e8, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0xf54, PAL_NONE,      0x7fd, PAL_NONE,  1,  1, 14, 14,   5, 0),
	M(     0xf54, PAL_NONE,      0x7fe, PAL_NONE,  1,  1, 14, 14,  44, 0),
	M(     0xf54, PAL_NONE,      0x7ff, PAL_NONE,  1,  1, 14, 14,  44, 0),
	M(     0xf54, PAL_NONE,      0x7ff, PAL_NONE,  1,  1, 14, 14,  44, 0),
	M(     0xf54, PAL_NONE,      0x800, PAL_NONE,  0,  2, 16, 12,   6, 0),
	M(     0xf54, PAL_NONE,      0x801, PAL_NONE,  0,  2, 16, 12,  47, 0),
	M(     0xf54, PAL_NONE,      0x802, PAL_NONE,  0,  2, 16, 12,  50, 0),
	M(     0xf54, PAL_NONE,      0x802, PAL_NONE,  0,  2, 16, 12,  50, 0),
	M(     0xf54, PAL_NONE,      0x803, PAL_NONE,  1,  0, 14, 15,   5, 0),
	M(     0xf54, PAL_NONE,      0x804, PAL_NONE,  1,  0, 14, 15,  19, 0),
	M(     0xf54, PAL_NONE,      0x805, PAL_NONE,  1,  0, 14, 15,  21, 0),
	M(     0xf54, PAL_NONE,      0x805, PAL_NONE,  1,  0, 14, 15,  21, 0),
	M(     0xf54, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0xf54, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0xf54, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0xf54, PAL_NONE,      0x806, PAL_NONE,  1,  2, 14, 11,  32, 5),
	M(     0xf54, PAL_NONE,      0x80d, PAL_NONE,  1,  0, 13, 16,   8, 0),
	M(     0xf54, PAL_NONE,      0x80e, PAL_NONE,  1,  0, 13, 16,  20, 0),
	M(     0xf54, PAL_NONE,      0x80f, PAL_NONE,  1,  0, 13, 16,  20, 0),
	M(     0xf54, PAL_NONE,      0x80f, PAL_NONE,  1,  0, 13, 16,  20, 0),
	M(     0xf54, PAL_NONE,      0x810, PAL_NONE,  0,  1, 16, 14,   8, 0),
	M(     0xf54, PAL_NONE,      0x811, PAL_NONE,  0,  1, 16, 14,  21, 0),
	M(     0xf54, PAL_NONE,      0x812, PAL_NONE,  0,  1, 16, 14,  21, 0),
	M(     0xf54, PAL_NONE,      0x812, PAL_NONE,  0,  1, 16, 14,  21, 0),
	M(     0xf54, PAL_NONE,      0x813, PAL_NONE,  1,  1, 14, 14,  12, 0),
	M(     0xf54, PAL_NONE,      0x814, PAL_NONE,  1,  1, 14, 14,  15, 0),
	M(     0xf54, PAL_NONE,      0x815, PAL_NONE,  1,  1, 14, 14,  22, 0),
	M(     0xf54, PAL_NONE,      0x815, PAL_NONE,  1,  1, 14, 14,  22, 0),
	M(     0xf54, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0xf54, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0xf54, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0xf54, PAL_NONE,      0x816, PAL_NONE,  0,  0, 16, 15,  20, 0),
	M(     0xf54, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0xf54, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0xf54, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0xf54, PAL_NONE,      0x817, PAL_NONE,  0,  1, 16, 13,  19, 0),
	M(     0x81d, PAL_NONE,      0x818, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(     0x81d, PAL_NONE,      0x819, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M(     0x81d, PAL_NONE,      0x81a, PAL_NONE,  0,  0, 16, 16,  31, 0),
	M(     0x81d, PAL_NONE,      0x81b, PAL_NONE,  0,  0, 16, 16,  39, 0),
	M(     0x81d, PAL_NONE,      0x81c, PAL_NONE,  0,  0, 16, 16,   7, 0),
	M(     0x81d, PAL_NONE,      0x81c, PAL_NONE,  0,  0, 16, 16,   7, 0),
	M(     0x81d, PAL_NONE,      0x81c, PAL_NONE,  0,  0, 16, 16,   7, 0),
	M(     0x81d, PAL_NONE,      0x81c, PAL_NONE,  0,  0, 16, 16,   7, 0),
	M(     0xf54, PAL_NONE,     0x81e | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  1,  1, 14, 14,   4, 0),
	M(     0xf54, PAL_NONE,     0x81f | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  1,  1, 14, 14,  24, 0),
	M(     0xf54, PAL_NONE,     0x820 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  1,  1, 14, 14,  27, 0),
	M(     0x58c, PAL_NONE,     0x820 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  1,  1, 14, 14,  27, 0),
	M(     0xf54, PAL_NONE,     0x821 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  3,  3, 10,  9,   3, 0),
	M(     0xf54, PAL_NONE,     0x822 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  3,  3, 10,  9,  63, 0),
	M(     0xf54, PAL_NONE,     0x823 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  3,  3, 10,  9,  62, 0),
	M(     0x58c, PAL_NONE,     0x823 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  3,  3, 10,  9,  62, 0),
	M(     0xf54, PAL_NONE,     0x824 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  4,  4,  7,  7,   3, 0),
	M(     0xf54, PAL_NONE,     0x825 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  4,  4,  7,  7,  72, 0),
	M(     0xf54, PAL_NONE,     0x825 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  4,  4,  7,  7,  72, 0),
	M(     0x58c, PAL_NONE,     0x826 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  4,  4,  7,  7,  80, 0),
	M(     0xf54, PAL_NONE,     0x827 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  2,  0, 12, 16,  51, 0),
	M(     0xf54, PAL_NONE,     0x828 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  2,  0, 12, 16,  51, 0),
	M(     0xf54, PAL_NONE,     0x829 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  2,  0, 12, 16,  51, 0),
	M(     0x58c, PAL_NONE,     0x829 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  2,  0, 12, 16,  51, 0),
	M(     0xf54, PAL_NONE,     0x82a | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  26, 0),
	M(     0xf54, PAL_NONE,     0x82b | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  44, 0),
	M(     0xf54, PAL_NONE,     0x82c | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  46, 0),
	M(     0x58c, PAL_NONE,     0x82c | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  46, 0),
	M(     0xf54, PAL_NONE,      0x82d, PAL_NONE,  3,  1, 10, 13,   2, 0),
	M(     0xf54, PAL_NONE,      0x82e, PAL_NONE,  3,  1, 10, 13,  11, 0),
	M(     0xf54, PAL_NONE,      0x82f, PAL_NONE,  3,  1, 10, 13,  11, 0),
	M(     0x58c, PAL_NONE,      0x82f, PAL_NONE,  3,  1, 10, 13,  11, 0),
	M(     0xfdd, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0xfdd, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0xfdd, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0xfdd, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0xfdd, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0xfdd, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0xfdd, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0xfdd, PAL_NONE,      0x833, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0xfdd, PAL_NONE,      0x837, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0xfdd, PAL_NONE,      0x834, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0xfdd, PAL_NONE,      0x834, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0xfdd, PAL_NONE,      0x830, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0xfdd, PAL_NONE,      0x838, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0xfdd, PAL_NONE,      0x835, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0xfdd, PAL_NONE,      0x835, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0xfdd, PAL_NONE,      0x831, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0xfdd, PAL_NONE,      0x839, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0xfdd, PAL_NONE,      0x836, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0xfdd, PAL_NONE,      0x836, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0xfdd, PAL_NONE,      0x832, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0x7e6, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0x87d, PAL_NONE,      0x87e, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0x87d, PAL_NONE,      0x87e, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0x87d, PAL_NONE,      0x87e, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0x87d, PAL_NONE,      0x87e, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0x87d, PAL_NONE,      0x87f, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0x87d, PAL_NONE,      0x880, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0x87d, PAL_NONE,      0x881, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0x87d, PAL_NONE,      0x882, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0x87d, PAL_NONE,      0x883, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0x87d, PAL_NONE,      0x883, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0x87d, PAL_NONE,      0x882, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0x87d, PAL_NONE,      0x881, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0x87d, PAL_NONE,      0x880, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0x87d, PAL_NONE,      0x87f, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0x87d, PAL_NONE,      0x87e, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0x83a, PAL_NONE,     0x83c | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  18, 0),
	M(     0x83a, PAL_NONE,     0x83c | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  18, 0),
	M(     0x83a, PAL_NONE,     0x83c | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  18, 0),
	M(     0x83a, PAL_NONE,     0x83c | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  18, 0),
	M(     0x83b, PAL_NONE,     0x83d | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  18, 0),
	M(     0x83b, PAL_NONE,     0x83d | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  18, 0),
	M(     0x83b, PAL_NONE,     0x83d | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  18, 0),
	M(     0x83b, PAL_NONE,     0x83d | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  18, 0),
	M(     0x7e6, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0x83e, PAL_NONE,     0x83f | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  18, 0),
	M(     0x83e, PAL_NONE,     0x83f | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  18, 0),
	M(     0x83e, PAL_NONE,     0x83f | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  18, 0),
	M(     0x7e6, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0x840, PAL_NONE,      0x841, PAL_NONE,  0,  0, 16, 16,  18, 0),
	M(     0x840, PAL_NONE,      0x841, PAL_NONE,  0,  0, 16, 16,  18, 0),
	M(     0x840, PAL_NONE,      0x841, PAL_NONE,  0,  0, 16, 16,  18, 0),
	M(     0x7e6, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0x842, PAL_NONE,      0x843, PAL_NONE,  0,  0, 16, 16,  30, 0),
	M(     0x842, PAL_NONE,      0x843, PAL_NONE,  0,  0, 16, 16,  30, 0),
	M(     0x842, PAL_NONE,      0x843, PAL_NONE,  0,  0, 16, 16,  30, 0),
	M(     0x7e6, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0x844, PAL_NONE,      0x845, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M(     0x844, PAL_NONE,      0x845, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M(     0x844, PAL_NONE,      0x845, PAL_NONE,  0,  0, 16, 16,  16, 0),
	M(     0x7e6, PAL_NONE,      0x869, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x86d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x86d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x862 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,     0x866 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x86a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x86e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x86e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x863 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,     0x867 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x86b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x86f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x86f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x864 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,     0x868 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x86c, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x870, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x870, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x865 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0xf54, PAL_NONE,     0x871 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf54, PAL_NONE,     0x875 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf54, PAL_NONE,     0x875 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf54, PAL_NONE,     0x879 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf54, PAL_NONE,     0x872 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf54, PAL_NONE,     0x876 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf54, PAL_NONE,     0x876 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf54, PAL_NONE,     0x87a | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf54, PAL_NONE,     0x873 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf54, PAL_NONE,     0x877 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf54, PAL_NONE,     0x877 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf54, PAL_NONE,     0x87b | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf54, PAL_NONE,     0x874 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf54, PAL_NONE,     0x878 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf54, PAL_NONE,     0x878 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf54, PAL_NONE,     0x87c | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf54, PAL_NONE,      0x7ea, PAL_NONE,  3,  2,  8,  8,  18, 0),
	M(     0xf54, PAL_NONE,      0x7eb, PAL_NONE,  3,  2,  8,  8,  37, 0),
	M(     0xf54, PAL_NONE,      0x7ec, PAL_NONE,  3,  2,  8,  8,  49, 0),
	M(     0x7e6, PAL_NONE,      0x7ec, PAL_NONE,  3,  2,  8,  8,  49, 0),
	M(     0x7e6, PAL_NONE,      0x7ec, PAL_NONE,  3,  2,  8,  8,  49, 0),
	M(     0x7e6, PAL_NONE,      0x7ed, PAL_NONE,  3,  2,  8,  8,  49, 0),
	M(     0x7e6, PAL_NONE,      0x7ee, PAL_NONE,  3,  2,  8,  8,  49, 0),
	M(     0x7e6, PAL_NONE,      0x7ee, PAL_NONE,  3,  2,  8,  8,  49, 0),
	M(     0xf54, PAL_NONE,      0x7ef, PAL_NONE,  3,  2, 10,  7,  20, 0),
	M(     0xf54, PAL_NONE,      0x7f0, PAL_NONE,  3,  2, 10,  7,  40, 0),
	M(     0xf54, PAL_NONE,      0x7f1, PAL_NONE,  3,  2, 10,  7,  40, 0),
	M(     0x7e6, PAL_NONE,      0x7f1, PAL_NONE,  3,  2, 10,  7,  40, 0),
	M(     0xf54, PAL_NONE,      0x7f2, PAL_NONE,  4,  4,  7,  8,  22, 0),
	M(     0xf54, PAL_NONE,      0x7f3, PAL_NONE,  4,  4,  7,  8,  22, 0),
	M(     0xf54, PAL_NONE,      0x7f4, PAL_NONE,  4,  4,  7,  8,  22, 0),
	M(     0x7e6, PAL_NONE,      0x7f4, PAL_NONE,  4,  4,  7,  8,  22, 0),
	M(     0xf54, PAL_NONE,      0x7f5, PAL_NONE,  2,  1, 11, 13,  12, 0),
	M(     0xf54, PAL_NONE,      0x7f6, PAL_NONE,  2,  1, 11, 13,  12, 0),
	M(     0xf54, PAL_NONE,      0x7f7, PAL_NONE,  2,  1, 11, 13,  12, 0),
	M(     0x7e6, PAL_NONE,      0x7f7, PAL_NONE,  2,  1, 11, 13,  12, 0),
	M(     0x7e6, PAL_NONE,      0x85c, PAL_NONE,  0,  0,  1,  1,   1, 0),
	M(     0x851, PAL_NONE,      0x852, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0x851, PAL_NONE,      0x852, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(    0x846 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,     0x847 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0x7e6, PAL_NONE,      0x85d, PAL_NONE,  0,  0,  1,  1,   1, 0),
	M(     0x853, PAL_NONE,      0x854, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0x853, PAL_NONE,      0x854, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(    0x848 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,     0x849 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0x7e6, PAL_NONE,      0x85e, PAL_NONE,  0,  0,  1,  1,   1, 0),
	M(     0x855, PAL_NONE,      0x856, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0x855, PAL_NONE,      0x856, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(    0x84a | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,     0x84b | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0x7e6, PAL_NONE,      0x85f, PAL_NONE,  0,  0,  1,  1,   1, 0),
	M(     0x857, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0x857, PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(    0x84c | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0x7e6, PAL_NONE,      0x860, PAL_NONE,  0,  0,  1,  1,   1, 0),
	M(     0x858, PAL_NONE,      0x859, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0x858, PAL_NONE,      0x859, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(    0x84d | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,     0x84e | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0x7e6, PAL_NONE,      0x861, PAL_NONE,  0,  0,  1,  1,   1, 0),
	M(     0x85a, PAL_NONE,      0x85b, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0x85a, PAL_NONE,      0x85b, PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(    0x84f | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,     0x850 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  20, 0),
	M(     0x7e6, PAL_NONE,      0x884, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x884, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x884, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x886, PAL_NONE,      0x884, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x885, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x885, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x885, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x887, PAL_NONE,      0x885, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,     0x88c | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,     0x88d | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,     0x88d | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,     0x88e | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,     0x88f | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,     0x890 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,     0x890 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,     0x891 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,     0x892 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,     0x893 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,     0x893 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,     0x894 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,     0x895 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,     0x896 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,     0x896 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,     0x897 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x898, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x899, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x899, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x89a, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8a6, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x89b, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x89c, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x89c, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x89d, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x89e, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x89f, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8a0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8a0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x89f, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8a0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8a1, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8a2, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8a3, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8a4, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8a2, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8a3, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8a5, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8a7, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8b7, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8b7, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8c7, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8a8, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8b8, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8b8, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8c8, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8a9, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8b9, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8b9, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8c9, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8aa, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8ba, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8ba, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8ca, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8ab, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8bb, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8bb, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8cb, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8ac, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8bc, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8bc, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8cc, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8ad, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8bd, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8bd, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8cd, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8ae, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8be, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8be, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8ce, PAL_NONE,      0x8d7, PAL_NONE,  0,  0, 16, 16,  35, 0),
	M(     0x8af, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8bf, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8bf, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8cf, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8b0, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8c0, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8c0, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8d0, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8b1, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8c1, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8c1, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8d1, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8b2, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8c2, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8c2, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8d2, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8b3, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8c3, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8c3, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8d3, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8b4, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8c4, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8c4, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8d4, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8b5, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8c5, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8c5, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8d5, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8b6, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8c6, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8c6, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8d6, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8ce, PAL_NONE,      0x8d7, PAL_NONE,  0,  0, 16, 16,  35, 0),
	M(     0x8ce, PAL_NONE,      0x8d8, PAL_NONE,  0,  0, 16, 16,  35, 0),
	M(     0x8ce, PAL_NONE,      0x8d9, PAL_NONE,  0,  0, 16, 16,  35, 0),
	M(     0x8ce, PAL_NONE,      0x8d9, PAL_NONE,  0,  0, 16, 16,  35, 0),
	M(     0x7e6, PAL_NONE,      0x88a, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x88a, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x88a, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x888, PAL_NONE,      0x88a, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x88b, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x88b, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x88b, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x889, PAL_NONE,      0x88b, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8da, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8e3, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8e3, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8ec, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8db, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8e4, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8e4, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8ed, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8dc, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8e5, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8e5, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8ee, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8dd, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8e6, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8e6, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8ef, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8de, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8e7, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8e7, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8f0, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8df, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8e8, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8e8, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8f1, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8e0, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8e9, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8e9, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x8f2, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8e1, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8ea, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8ea, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8f3, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8e2, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8eb, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8eb, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8f4, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8f5, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x905, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x905, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x915, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8f6, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x906, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x906, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x916, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8f7, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x907, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x907, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x917, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8f8, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x908, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x908, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x918, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8f9, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x909, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x909, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x919, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8fa, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x90a, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x90a, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x91a, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8fb, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x90b, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x90b, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x91b, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8fc, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x90c, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x90c, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x91c, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8fd, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x90d, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x90d, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x91d, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8fe, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x90e, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x90e, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x91e, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x8ff, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x90f, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x90f, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x91f, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x900, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x910, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x910, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x920, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x901, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x911, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x911, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x921, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x902, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x912, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x912, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x922, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x903, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x913, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x913, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x923, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x904, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x914, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x914, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x924, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x925, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x925, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x925, PAL_NONE,      0x926, PAL_NONE,  0,  0, 16, 16,  30, 0),
	M(     0x925, PAL_NONE,      0x926, PAL_NONE,  0,  0, 16, 16,  30, 0),
	M(     0x925, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x925, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x925, PAL_NONE,      0x927, PAL_NONE,  0,  0, 16, 16,  30, 0),
	M(     0x925, PAL_NONE,      0x927, PAL_NONE,  0,  0, 16, 16,  30, 0),
	M(    0x11c6, PAL_NONE,     0x92b | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(    0x11c6, PAL_NONE,     0x92c | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(    0x11c6, PAL_NONE,     0x92c | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(    0x11c6, PAL_NONE,     0x92d | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(    0x11c6, PAL_NONE,     0x92e | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(    0x11c6, PAL_NONE,     0x92f | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(    0x11c6, PAL_NONE,     0x92f | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(    0x11c6, PAL_NONE,     0x930 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(    0x11c6, PAL_NONE,     0x928 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(    0x11c6, PAL_NONE,     0x929 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(    0x11c6, PAL_NONE,     0x929 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(    0x11c6, PAL_NONE,     0x92a | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  25, 0),
	M(     0x7e6, PAL_NONE,      0x869, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x86d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x86d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x862 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,     0x866 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x86a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x86e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x86e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x863 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,     0x867 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x86b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x86f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x86f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x864 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,     0x868 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x86c, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x870, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x870, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x865 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,        0x0, PAL_NONE,  0,  0,  1,  1,   0, 0),
	M(     0x7e6, PAL_NONE,      0x931, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x935, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x935, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x939, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x932, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x936, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x936, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x93a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x933, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x937, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x937, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x93b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x934, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x938, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x938, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,      0x93c, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x81d, PAL_NONE,      0x818, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(     0x81d, PAL_NONE,      0x819, PAL_NONE,  0,  0, 16, 16,  15, 0),
	M(     0x81d, PAL_NONE,      0x81a, PAL_NONE,  0,  0, 16, 16,  31, 0),
	M(     0x81d, PAL_NONE,      0x81b, PAL_NONE,  0,  0, 16, 16,  39, 0),
	M(     0x81d, PAL_NONE,      0x81c, PAL_NONE,  0,  0, 16, 16,   7, 0),
	M(     0x81d, PAL_NONE,      0x81c, PAL_NONE,  0,  0, 16, 16,   7, 0),
	M(     0x81d, PAL_NONE,      0x81c, PAL_NONE,  0,  0, 16, 16,   7, 0),
	M(     0x81d, PAL_NONE,      0x81c, PAL_NONE,  0,  0, 16, 16,   7, 0),
	M(     0x7e6, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,     0x1245 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,     0x1248 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,     0x1248 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,     0x124b | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,     0x1247 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,     0x124a | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,     0x124a | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,     0x124d | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,     0x1246 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,     0x1249 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,     0x1249 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,     0x124c | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x81d, PAL_NONE,     0x124e, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(     0x81d, PAL_NONE,     0x124f, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(     0x81d, PAL_NONE,     0x1250, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(     0x81d, PAL_NONE,     0x1251, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(     0x81d, PAL_NONE,     0x1252, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(     0x81d, PAL_NONE,     0x1252, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(     0x81d, PAL_NONE,     0x1252, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(     0x81d, PAL_NONE,     0x1252, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(     0x81d, PAL_NONE,     0x1253, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(     0x81d, PAL_NONE,     0x1254, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(     0x81d, PAL_NONE,     0x1254, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(     0x81d, PAL_NONE,     0x1255, PAL_NONE,  0,  0, 16, 16,  10, 0),
	M(     0x7e6, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,     0x125b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,     0x125e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,     0x125e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,     0x1261, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,     0x125c, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,     0x125f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,     0x125f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,     0x1262, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,     0x125d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,     0x1260, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,     0x1260, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0x7e6, PAL_NONE,     0x1263, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1243, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1243, PAL_NONE,     0x1264, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1243, PAL_NONE,     0x1264, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1243, PAL_NONE,     0x1268, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1243, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1243, PAL_NONE,     0x1265, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1243, PAL_NONE,     0x1265, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1243, PAL_NONE,     0x1269, PAL_NONE,  0,  0, 16, 16,  50, 4),
	M(    0x1243, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1243, PAL_NONE,     0x1266, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1243, PAL_NONE,     0x1266, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1243, PAL_NONE,     0x126a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1243, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1243, PAL_NONE,     0x1267, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1243, PAL_NONE,     0x1267, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1243, PAL_NONE,     0x126b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1243, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1243, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1243, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1243, PAL_NONE,     0x126c, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1243, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1243, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1243, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1243, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1271, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1271, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1271, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1271, PAL_NONE,     0x1279, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1272, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1272, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1272, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1272, PAL_NONE,     0x127a, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1273, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1273, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1273, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1273, PAL_NONE,     0x127b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1274, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1274, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1274, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1274, PAL_NONE,     0x127c, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1275, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1275, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1275, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1275, PAL_NONE,     0x127d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1276, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1276, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1276, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1276, PAL_NONE,     0x127e, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1277, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1277, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1277, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1277, PAL_NONE,     0x127f, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1278, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1278, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1278, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1278, PAL_NONE,     0x1280, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1244, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1244, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1244, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1244, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1244, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1244, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1244, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1244, PAL_NONE,     0x1284 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1244, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1244, PAL_NONE,     0x1283 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1244, PAL_NONE,     0x1283 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1244, PAL_NONE,     0x1286 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1244, PAL_NONE,     0x1281 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1244, PAL_NONE,     0x1282 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1244, PAL_NONE,     0x1282 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1244, PAL_NONE,     0x1285 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1243, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1243, PAL_NONE,     0x1287 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1243, PAL_NONE,     0x1287 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1243, PAL_NONE,     0x1287 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1244, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1244, PAL_NONE,     0x1288 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1244, PAL_NONE,     0x1288 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1244, PAL_NONE,     0x1288 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1243, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1243, PAL_NONE,     0x1289 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 3),
	M(    0x1243, PAL_NONE,     0x1289 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 3),
	M(    0x1243, PAL_NONE,     0x1289 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 3),
	M(    0x1244, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1244, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1244, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x1244, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf8d, PAL_NONE,     0x129b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf8d, PAL_NONE,     0x129b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf8d, PAL_NONE,     0x129b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf8d, PAL_NONE,     0x129b, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf8d, PAL_NONE,     0x129c, PAL_NONE,  0,  0, 16, 16,  50, 2),
	M(     0xf8d, PAL_NONE,     0x129c, PAL_NONE,  0,  0, 16, 16,  50, 2),
	M(     0xf8d, PAL_NONE,     0x129c, PAL_NONE,  0,  0, 16, 16,  50, 2),
	M(     0xf8d, PAL_NONE,     0x129c, PAL_NONE,  0,  0, 16, 16,  50, 2),
	M(     0xf8d, PAL_NONE,     0x129d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf8d, PAL_NONE,     0x129d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf8d, PAL_NONE,     0x129d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf8d, PAL_NONE,     0x129d, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x12a0 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x12a0 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x12a0 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x12a0 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x12a1 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x12a1 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x12a1 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x12a1 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x12a2 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x12a2 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x12a2 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x12a2 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x12a3 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x12a3 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x12a3 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(    0x12a3 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf8d, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf8d, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf8d, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf8d, PAL_NONE,        0x0, PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf8d, PAL_NONE,     0x12a4 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf8d, PAL_NONE,     0x12a4 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf8d, PAL_NONE,     0x12a4 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf8d, PAL_NONE,     0x12a4 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf8d, PAL_NONE,     0x12a6 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf8d, PAL_NONE,     0x12a6 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf8d, PAL_NONE,     0x12a6 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf8d, PAL_NONE,     0x12a6 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 0),
	M(     0xf8d, PAL_NONE,     0x12a5 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 1),
	M(     0xf8d, PAL_NONE,     0x12a5 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 1),
	M(     0xf8d, PAL_NONE,     0x12a5 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 1),
	M(     0xf8d, PAL_NONE,     0x12a5 | (1 << PALETTE_MODIFIER_COLOUR), PAL_NONE,  0,  0, 16, 16,  50, 1),
};
#undef M

/* this is ONLY used for Sugar Mine*/
static const DrawIndustryAnimationStruct _draw_industry_spec1[96] = {
	{  8,   4,   0,   0},
	{  6,   0,   1,   0},
	{  4,   0,   2,   0},
	{  6,   0,   3,   0},
	{  8,   0,   4,   0},
	{ 10,   0,   5,   0},
	{ 12,   0,   6,   0},
	{ 10,   0,   1,   0},
	{  8,   0,   2,   0},
	{  6,   0,   3,   0},
	{  4,   0,   4,   0},
	{  6,   0,   5,   1},
	{  8,   0,   6,   1},
	{ 10,   0,   1,   1},
	{ 12,   0,   2,   1},
	{ 10,   0,   3,   1},
	{  8,   1,   4,   1},
	{  6,   1,   5,   1},
	{  4,   1,   6,   1},
	{  6,   1,   1,   1},
	{  8,   1,   2,   1},
	{ 10,   1,   3,   1},
	{ 12,   1,   4,   1},
	{ 10,   1,   5,   2},
	{  8,   1,   6,   2},
	{  6,   1,   1,   2},
	{  4,   1,   2,   2},
	{  6,   1,   3,   2},
	{  8,   1,   4,   2},
	{ 10,   1,   5,   2},
	{ 12,   1,   6,   2},
	{ 10,   1,   1,   2},
	{  8,   2,   2,   2},
	{  6,   2,   3,   2},
	{  4,   2,   4,   3},
	{  6,   2,   5,   3},
	{  8,   2,   6,   3},
	{ 10,   2,   1,   3},
	{ 12,   2,   2,   3},
	{ 10,   2,   3,   3},
	{  8,   2,   4,   3},
	{  6,   2,   5,   3},
	{  4,   2,   6,   3},
	{  6,   2,   1,   3},
	{  8,   2,   2,   3},
	{ 10,   2,   3,   4},
	{ 12,   2,   4,   4},
	{ 10,   2,   5,   4},
	{  8,   3,   6,   4},
	{  6,   3,   1,   4},
	{  4,   3,   2,   4},
	{  6,   3,   3,   4},
	{  8,   3,   4,   4},
	{ 10,   3,   5,   4},
	{ 12,   3,   6,   4},
	{ 10,   3,   1,   4},
	{  8,   3,   2,   4},
	{  6,   3,   3,   4},
	{  4,   3,   4,   4},
	{  6,   3,   5,   4},
	{  8,   3,   6,   4},
	{ 10,   3,   1,   4},
	{ 12,   3,   2,   4},
	{ 10,   3,   3,   4},
	{  8,   4,   4,   4},
	{  6,   4,   5,   4},
	{  4,   4,   6,   4},
	{  6,   4,   0,   4},
	{  8,   4,   0,   4},
	{ 10,   4,   0,   4},
	{ 12,   4,   0,   4},
	{ 10,   4,   0,   4},
	{  8,   4,   0,   4},
	{  6,   4,   0,   4},
	{  4,   4,   0,   4},
	{  6,   4,   0,   4},
	{  8,   4,   0,   4},
	{ 10,   4,   0,   4},
	{ 12,   4,   0,   4},
	{ 10,   4,   0,   4},
	{  8,   4,   0,   4},
	{  6,   4,   0,   4},
	{  4,   4,   0,   4},
	{  6,   4,   0,   4},
	{  8,   4,   0,   4},
	{ 10,   4,   0,   4},
	{ 12,   4,   0,   4},
	{ 10,   4,   0,   4},
	{  8,   4,   0,   4},
	{  6,   4,   0,   4},
	{  4,   4,   0,   4},
	{  6,   4,   0,   4},
	{  8,   4,   0,   4},
	{ 10,   4,   0,   4},
	{ 12,   4,   0,   4},
	{ 10,   4,   0,   4},
};

/* this is ONLY used for Sugar Mine*/
static const DrawIndustryCoordinates _drawtile_proc1[5] = {
	{22, 73},
	{17, 70},
	{14, 69},
	{10, 66},
	{ 8, 41},
};

/** this is ONLY used for Toy Factory.
 * 255 means no drawing
 * @param img1 offset from base sprite SPR_IT_SUGAR_MINE_SIEVE
 * @param img2 offset from base sprite SPR_IT_SUGAR_MINE_CLOUDS
 * @param img3 offset from base sprite SPR_IT_SUGAR_MINE_PILE
 */
#define MD( img1, img2, img3) { (50 - img1 * 2), img1, img2, img3 }
static const DrawIndustryAnimationStruct _industry_anim_offs_toys[] = {
	MD(255, 255,   0),
	MD(  0, 255,   0),
	MD(  1, 255,   0),
	MD(  2, 255,   0),
	MD(  3, 255,   0),
	MD(  4, 255,   0),
	MD(  5, 255,   0),
	MD(  6, 255,   0),
	MD(  7, 255,   0),
	MD(  8, 255,   0),
	MD(  9, 255,   0),
	MD( 10, 255,   0),
	MD( 11, 255,   0),
	MD( 12, 255,   0),
	MD( 13, 255,   0),
	MD( 14, 255,   0),
	MD( 15, 255,   0),
	MD( 16, 255,   0),
	MD( 17, 255,   0),
	MD( 18, 255,   0),
	MD( 18, 255,   1),
	MD( 18, 255,   2),
	MD( 18, 255,   4),
	MD( 18, 255,   6),
	MD( 18, 255,   8),
	MD( 18, 255,  11),
	MD( 18, 255,  14),
	MD( 18, 255,  17),
	MD( 18, 255,  20),
	MD( 18, 255,  24),
	MD(255,   0,  29),
	MD(255,   0,  24),
	MD(255,   0,  20),
	MD(255,   0,  17),
	MD(255,   0,  14),
	MD(255,   0,  11),
	MD(255,   0,   8),
	MD(255,   0,   6),
	MD(255,   0,   4),
	MD(255,   0,   2),
	MD(255,   0,   1),
	MD(255,   1,   0),
	MD(255,   2,   0),
	MD(255,   3,   0),
	MD(255,   4,   0),
	MD(255,   5,   0),
	MD(255,   6,   0),
	MD(255,   7,   0),
	MD(255,   8,   0),
	MD(255, 255,   0),
};
#undef MD

/* this is ONLY used for Toffee Quarry*/
static const byte _industry_anim_offs_toffee[] = {
	255,   0,   0,   0,   2,   4,   6,   8,  10,   9,
	  7,   5,   3,   1, 255,   0,   0,   0,   2,   4,
	  6,   8,  10,   9,   7,   5,   3,   1, 255,   0,
	  0,   0,   2,   4,   6,   8,  10,   9,   7,   5,
	  3,   1, 255,   0,   0,   0,   2,   4,   6,   8,
	 10,   9,   7,   5,   3,   1, 255,   0,   0,   0,
	  2,   4,   6,   8,  10,   9,   7,   5,   3,   1
};

/* this is ONLY used for the Bubble Generator*/
static const byte _industry_anim_offs_bubbles[] = {
	68, 69, 71, 74, 77, 80, 83, 85, 86, 86,
	86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
	86, 86, 85, 84, 83, 82, 81, 80, 79, 78,
	77, 76, 75, 74, 73, 72, 71, 70, 69, 68,
};

/**
 * Movement of the sparks , only used for Power Station
 */
static const DrawIndustryCoordinates _coal_plant_sparks[] = {
	{11, 23},
	{11, 11},
	{14,  6},
	{13,  3},
	{18,  1},
	{15,  0},
};

